/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.filters;

import java.util.ArrayList;
import java.util.List;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.filters.ComparableFilter;
import org.dizitart.no2.index.IndexMap;

class NotEqualsFilter
extends ComparableFilter {
    protected NotEqualsFilter(String field, Object value) {
        super(field, value);
    }

    @Override
    public boolean apply(Pair<NitriteId, Document> element) {
        Document document = element.getSecond();
        Object fieldValue = document.get(this.getField());
        return !ObjectUtils.deepEquals(fieldValue, this.getValue());
    }

    @Override
    public List<?> applyOnIndex(IndexMap indexMap) {
        ArrayList subMap = new ArrayList();
        ArrayList<NitriteId> nitriteIds = new ArrayList<NitriteId>();
        for (Pair<Comparable<?>, ?> entry : indexMap.entries()) {
            if (ObjectUtils.deepEquals(this.getValue(), entry.getFirst())) continue;
            this.processIndexValue(entry.getSecond(), subMap, nitriteIds);
        }
        if (!subMap.isEmpty()) {
            return subMap;
        }
        return nitriteIds;
    }

    @Override
    public String toString() {
        return "(" + this.getField() + " != " + String.valueOf(this.getValue()) + ")";
    }
}

