/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.filters;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import lombok.Generated;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.util.StringUtils;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.exceptions.FilterException;
import org.dizitart.no2.filters.StringFilter;
import org.dizitart.no2.index.IndexMap;
import org.dizitart.no2.index.fulltext.TextTokenizer;
import org.dizitart.no2.store.NitriteMap;

public class TextFilter
extends StringFilter {
    private TextTokenizer textTokenizer;

    TextFilter(String field, String value) {
        super(field, value);
    }

    @Override
    public boolean applyOnString(String value) {
        String searchString = (String)this.getValue();
        if (searchString.startsWith("*") || searchString.endsWith("*")) {
            searchString = searchString.replace("*", "");
        }
        return value.toLowerCase().contains(searchString.toLowerCase());
    }

    @Override
    public boolean apply(Pair<NitriteId, Document> element) {
        ValidationUtils.notNull(this.getField(), "field cannot be null");
        ValidationUtils.notNull(this.getStringValue(), "search term cannot be null");
        Object docValue = element.getSecond().get(this.getField());
        if (!(docValue instanceof String)) {
            throw new FilterException("Text filter can not be applied on non string field " + this.getField());
        }
        String docString = (String)docValue;
        return this.applyOnString(docString);
    }

    @Override
    public String toString() {
        return "(" + this.getField() + " like " + String.valueOf(this.getValue()) + ")";
    }

    public LinkedHashSet<NitriteId> applyOnTextIndex(NitriteMap<String, List<?>> indexMap) {
        ValidationUtils.notNull(this.getField(), "field cannot be null");
        ValidationUtils.notNull(this.getStringValue(), "search term cannot be null");
        String searchString = this.getStringValue();
        if (searchString.startsWith("*") || searchString.endsWith("*")) {
            return this.searchByWildCard(indexMap, searchString);
        }
        return this.searchExactByIndex(indexMap, searchString);
    }

    private LinkedHashSet<NitriteId> searchExactByIndex(NitriteMap<String, List<?>> indexMap, String searchString) {
        Set<String> words = this.textTokenizer.tokenize(searchString);
        HashMap<NitriteId, Integer> scoreMap = new HashMap<NitriteId, Integer>();
        for (String word : words) {
            List<?> nitriteIds = indexMap.get(word);
            if (nitriteIds == null) continue;
            for (NitriteId id : nitriteIds) {
                scoreMap.merge(id, 1, Integer::sum);
            }
        }
        return this.sortedIdsByScore(scoreMap);
    }

    private LinkedHashSet<NitriteId> searchByWildCard(NitriteMap<String, List<?>> indexMap, String searchString) {
        if (searchString.contentEquals("*")) {
            throw new FilterException("* is not a valid search term");
        }
        StringTokenizer stringTokenizer = StringUtils.stringTokenizer(searchString);
        if (stringTokenizer.countTokens() > 1) {
            throw new FilterException("Wild card search can not be applied on multiple words");
        }
        if (searchString.startsWith("*") && !searchString.endsWith("*")) {
            return this.searchByLeadingWildCard(indexMap, searchString);
        }
        if (searchString.endsWith("*") && !searchString.startsWith("*")) {
            return this.searchByTrailingWildCard(indexMap, searchString);
        }
        String term = searchString.substring(1, searchString.length() - 1);
        return this.searchContains(indexMap, term);
    }

    private LinkedHashSet<NitriteId> searchByLeadingWildCard(NitriteMap<String, List<?>> indexMap, String searchString) {
        if (searchString.equalsIgnoreCase("*")) {
            throw new FilterException("* is not a valid search term");
        }
        LinkedHashSet<NitriteId> idSet = new LinkedHashSet<NitriteId>();
        String term = searchString.substring(1);
        for (Pair pair : indexMap.entries()) {
            String key = (String)pair.getFirst();
            if (!key.endsWith(term.toLowerCase())) continue;
            idSet.addAll((List)pair.getSecond());
        }
        return idSet;
    }

    private LinkedHashSet<NitriteId> searchByTrailingWildCard(NitriteMap<String, List<?>> indexMap, String searchString) {
        if (searchString.equalsIgnoreCase("*")) {
            throw new FilterException("* is not a valid search term");
        }
        LinkedHashSet<NitriteId> idSet = new LinkedHashSet<NitriteId>();
        String term = searchString.substring(0, searchString.length() - 1);
        for (Pair pair : indexMap.entries()) {
            String key = (String)pair.getFirst();
            if (!key.startsWith(term.toLowerCase())) continue;
            idSet.addAll((List)pair.getSecond());
        }
        return idSet;
    }

    private LinkedHashSet<NitriteId> searchContains(NitriteMap<String, List<?>> indexMap, String term) {
        LinkedHashSet<NitriteId> idSet = new LinkedHashSet<NitriteId>();
        for (Pair pair : indexMap.entries()) {
            String key = (String)pair.getFirst();
            if (!key.contains(term.toLowerCase())) continue;
            idSet.addAll((List)pair.getSecond());
        }
        return idSet;
    }

    private LinkedHashSet<NitriteId> sortedIdsByScore(Map<NitriteId, Integer> unsortedMap) {
        LinkedList<Map.Entry<NitriteId, Integer>> list = new LinkedList<Map.Entry<NitriteId, Integer>>(unsortedMap.entrySet());
        list.sort((e1, e2) -> ((Integer)e2.getValue()).compareTo((Integer)e1.getValue()));
        LinkedHashSet<NitriteId> result = new LinkedHashSet<NitriteId>();
        for (Map.Entry entry : list) {
            result.add((NitriteId)entry.getKey());
        }
        return result;
    }

    @Override
    public List<?> applyOnIndex(IndexMap indexMap) {
        return null;
    }

    @Generated
    public void setTextTokenizer(TextTokenizer textTokenizer) {
        this.textTokenizer = textTokenizer;
    }
}

