/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.index;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.collection.FindPlan;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.FieldValues;
import org.dizitart.no2.common.Fields;
import org.dizitart.no2.exceptions.IndexingException;
import org.dizitart.no2.index.IndexDescriptor;
import org.dizitart.no2.index.NitriteIndexer;
import org.dizitart.no2.index.TextIndex;
import org.dizitart.no2.index.fulltext.EnglishTextTokenizer;
import org.dizitart.no2.index.fulltext.TextTokenizer;

public class NitriteTextIndexer
implements NitriteIndexer {
    private final TextTokenizer textTokenizer;
    private final Map<IndexDescriptor, TextIndex> indexRegistry;

    public NitriteTextIndexer() {
        this.textTokenizer = new EnglishTextTokenizer();
        this.indexRegistry = new ConcurrentHashMap<IndexDescriptor, TextIndex>();
    }

    public NitriteTextIndexer(TextTokenizer textTokenizer) {
        this.textTokenizer = textTokenizer;
        this.indexRegistry = new ConcurrentHashMap<IndexDescriptor, TextIndex>();
    }

    @Override
    public void initialize(NitriteConfig nitriteConfig) {
    }

    @Override
    public String getIndexType() {
        return "Fulltext";
    }

    @Override
    public void validateIndex(Fields fields) {
        if (fields.getFieldNames().size() > 1) {
            throw new IndexingException("Text index can only be created on a single field");
        }
    }

    @Override
    public void dropIndex(IndexDescriptor indexDescriptor, NitriteConfig nitriteConfig) {
        TextIndex textIndex = this.findTextIndex(indexDescriptor, nitriteConfig);
        textIndex.drop();
    }

    @Override
    public void writeIndexEntry(FieldValues fieldValues, IndexDescriptor indexDescriptor, NitriteConfig nitriteConfig) {
        TextIndex textIndex = this.findTextIndex(indexDescriptor, nitriteConfig);
        textIndex.write(fieldValues);
    }

    @Override
    public void removeIndexEntry(FieldValues fieldValues, IndexDescriptor indexDescriptor, NitriteConfig nitriteConfig) {
        TextIndex textIndex = this.findTextIndex(indexDescriptor, nitriteConfig);
        textIndex.remove(fieldValues);
    }

    @Override
    public LinkedHashSet<NitriteId> findByFilter(FindPlan findPlan, NitriteConfig nitriteConfig) {
        TextIndex textIndex = this.findTextIndex(findPlan.getIndexDescriptor(), nitriteConfig);
        return textIndex.findNitriteIds(findPlan);
    }

    @Override
    public void close() {
        this.indexRegistry.clear();
    }

    private TextIndex findTextIndex(IndexDescriptor indexDescriptor, NitriteConfig nitriteConfig) {
        if (this.indexRegistry.containsKey(indexDescriptor)) {
            return this.indexRegistry.get(indexDescriptor);
        }
        TextIndex textIndex = new TextIndex(this.textTokenizer, indexDescriptor, nitriteConfig.getNitriteStore());
        this.indexRegistry.put(indexDescriptor, textIndex);
        return textIndex;
    }
}

