/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.index.fulltext;

import java.util.HashSet;
import java.util.Set;
import org.dizitart.no2.common.util.Iterables;
import org.dizitart.no2.index.fulltext.BaseTextTokenizer;
import org.dizitart.no2.index.fulltext.Language;
import org.dizitart.no2.index.fulltext.Languages;
import org.dizitart.no2.index.fulltext.languages.Afrikaans;
import org.dizitart.no2.index.fulltext.languages.Arabic;
import org.dizitart.no2.index.fulltext.languages.Armenian;
import org.dizitart.no2.index.fulltext.languages.Basque;
import org.dizitart.no2.index.fulltext.languages.Bengali;
import org.dizitart.no2.index.fulltext.languages.BrazilianPortuguese;
import org.dizitart.no2.index.fulltext.languages.Breton;
import org.dizitart.no2.index.fulltext.languages.Bulgarian;
import org.dizitart.no2.index.fulltext.languages.Catalan;
import org.dizitart.no2.index.fulltext.languages.Chinese;
import org.dizitart.no2.index.fulltext.languages.Croatian;
import org.dizitart.no2.index.fulltext.languages.Czech;
import org.dizitart.no2.index.fulltext.languages.Danish;
import org.dizitart.no2.index.fulltext.languages.Dutch;
import org.dizitart.no2.index.fulltext.languages.English;
import org.dizitart.no2.index.fulltext.languages.Esperanto;
import org.dizitart.no2.index.fulltext.languages.Estonian;
import org.dizitart.no2.index.fulltext.languages.Finnish;
import org.dizitart.no2.index.fulltext.languages.French;
import org.dizitart.no2.index.fulltext.languages.Galician;
import org.dizitart.no2.index.fulltext.languages.German;
import org.dizitart.no2.index.fulltext.languages.Greek;
import org.dizitart.no2.index.fulltext.languages.Hausa;
import org.dizitart.no2.index.fulltext.languages.Hebrew;
import org.dizitart.no2.index.fulltext.languages.Hindi;
import org.dizitart.no2.index.fulltext.languages.Hungarian;
import org.dizitart.no2.index.fulltext.languages.Indonesian;
import org.dizitart.no2.index.fulltext.languages.Irish;
import org.dizitart.no2.index.fulltext.languages.Italian;
import org.dizitart.no2.index.fulltext.languages.Japanese;
import org.dizitart.no2.index.fulltext.languages.Korean;
import org.dizitart.no2.index.fulltext.languages.Kurdish;
import org.dizitart.no2.index.fulltext.languages.Latin;
import org.dizitart.no2.index.fulltext.languages.Latvian;
import org.dizitart.no2.index.fulltext.languages.Lithuanian;
import org.dizitart.no2.index.fulltext.languages.Malay;
import org.dizitart.no2.index.fulltext.languages.Marathi;
import org.dizitart.no2.index.fulltext.languages.Norwegian;
import org.dizitart.no2.index.fulltext.languages.Persian;
import org.dizitart.no2.index.fulltext.languages.Polish;
import org.dizitart.no2.index.fulltext.languages.Portuguese;
import org.dizitart.no2.index.fulltext.languages.Romanian;
import org.dizitart.no2.index.fulltext.languages.Russian;
import org.dizitart.no2.index.fulltext.languages.Sesotho;
import org.dizitart.no2.index.fulltext.languages.Slovak;
import org.dizitart.no2.index.fulltext.languages.Slovenian;
import org.dizitart.no2.index.fulltext.languages.Somali;
import org.dizitart.no2.index.fulltext.languages.Spanish;
import org.dizitart.no2.index.fulltext.languages.Swahili;
import org.dizitart.no2.index.fulltext.languages.Swedish;
import org.dizitart.no2.index.fulltext.languages.Tagalog;
import org.dizitart.no2.index.fulltext.languages.Thai;
import org.dizitart.no2.index.fulltext.languages.Turkish;
import org.dizitart.no2.index.fulltext.languages.Ukrainian;
import org.dizitart.no2.index.fulltext.languages.Urdu;
import org.dizitart.no2.index.fulltext.languages.Vietnamese;
import org.dizitart.no2.index.fulltext.languages.Yoruba;
import org.dizitart.no2.index.fulltext.languages.Zulu;

public class UniversalTextTokenizer
extends BaseTextTokenizer {
    private final Set<String> stopWords = new HashSet<String>();

    public UniversalTextTokenizer() {
        this.loadAllLanguages();
    }

    public UniversalTextTokenizer(Languages ... languages) {
        if (Iterables.arrayContains(languages, Languages.ALL)) {
            this.loadAllLanguages();
        } else {
            this.loadLanguage(languages);
        }
    }

    @Override
    public Languages getLanguage() {
        return Languages.ALL;
    }

    @Override
    public Set<String> stopWords() {
        return this.stopWords;
    }

    private void loadAllLanguages() {
        this.loadLanguage(Languages.values());
    }

    private void loadLanguage(Languages ... languages) {
        block60: for (Languages language : languages) {
            switch (language) {
                case Afrikaans: {
                    this.registerLanguage(new Afrikaans());
                    continue block60;
                }
                case Arabic: {
                    this.registerLanguage(new Arabic());
                    continue block60;
                }
                case Armenian: {
                    this.registerLanguage(new Armenian());
                    continue block60;
                }
                case Basque: {
                    this.registerLanguage(new Basque());
                    continue block60;
                }
                case Bengali: {
                    this.registerLanguage(new Bengali());
                    continue block60;
                }
                case BrazilianPortuguese: {
                    this.registerLanguage(new BrazilianPortuguese());
                    continue block60;
                }
                case Breton: {
                    this.registerLanguage(new Breton());
                    continue block60;
                }
                case Bulgarian: {
                    this.registerLanguage(new Bulgarian());
                    continue block60;
                }
                case Catalan: {
                    this.registerLanguage(new Catalan());
                    continue block60;
                }
                case Chinese: {
                    this.registerLanguage(new Chinese());
                    continue block60;
                }
                case Croatian: {
                    this.registerLanguage(new Croatian());
                    continue block60;
                }
                case Czech: {
                    this.registerLanguage(new Czech());
                    continue block60;
                }
                case Danish: {
                    this.registerLanguage(new Danish());
                    continue block60;
                }
                case Dutch: {
                    this.registerLanguage(new Dutch());
                    continue block60;
                }
                case English: {
                    this.registerLanguage(new English());
                    continue block60;
                }
                case Esperanto: {
                    this.registerLanguage(new Esperanto());
                    continue block60;
                }
                case Estonian: {
                    this.registerLanguage(new Estonian());
                    continue block60;
                }
                case Finnish: {
                    this.registerLanguage(new Finnish());
                    continue block60;
                }
                case French: {
                    this.registerLanguage(new French());
                    continue block60;
                }
                case Galician: {
                    this.registerLanguage(new Galician());
                    continue block60;
                }
                case German: {
                    this.registerLanguage(new German());
                    continue block60;
                }
                case Greek: {
                    this.registerLanguage(new Greek());
                    continue block60;
                }
                case Hausa: {
                    this.registerLanguage(new Hausa());
                    continue block60;
                }
                case Hebrew: {
                    this.registerLanguage(new Hebrew());
                    continue block60;
                }
                case Hindi: {
                    this.registerLanguage(new Hindi());
                    continue block60;
                }
                case Hungarian: {
                    this.registerLanguage(new Hungarian());
                    continue block60;
                }
                case Indonesian: {
                    this.registerLanguage(new Indonesian());
                    continue block60;
                }
                case Irish: {
                    this.registerLanguage(new Irish());
                    continue block60;
                }
                case Italian: {
                    this.registerLanguage(new Italian());
                    continue block60;
                }
                case Japanese: {
                    this.registerLanguage(new Japanese());
                    continue block60;
                }
                case Korean: {
                    this.registerLanguage(new Korean());
                    continue block60;
                }
                case Kurdish: {
                    this.registerLanguage(new Kurdish());
                    continue block60;
                }
                case Latin: {
                    this.registerLanguage(new Latin());
                    continue block60;
                }
                case Latvian: {
                    this.registerLanguage(new Latvian());
                    continue block60;
                }
                case Lithuanian: {
                    this.registerLanguage(new Lithuanian());
                    continue block60;
                }
                case Malay: {
                    this.registerLanguage(new Malay());
                    continue block60;
                }
                case Marathi: {
                    this.registerLanguage(new Marathi());
                    continue block60;
                }
                case Norwegian: {
                    this.registerLanguage(new Norwegian());
                    continue block60;
                }
                case Persian: {
                    this.registerLanguage(new Persian());
                    continue block60;
                }
                case Polish: {
                    this.registerLanguage(new Polish());
                    continue block60;
                }
                case Portuguese: {
                    this.registerLanguage(new Portuguese());
                    continue block60;
                }
                case Romanian: {
                    this.registerLanguage(new Romanian());
                    continue block60;
                }
                case Russian: {
                    this.registerLanguage(new Russian());
                    continue block60;
                }
                case Sesotho: {
                    this.registerLanguage(new Sesotho());
                    continue block60;
                }
                case Slovak: {
                    this.registerLanguage(new Slovak());
                    continue block60;
                }
                case Slovenian: {
                    this.registerLanguage(new Slovenian());
                    continue block60;
                }
                case Somali: {
                    this.registerLanguage(new Somali());
                    continue block60;
                }
                case Spanish: {
                    this.registerLanguage(new Spanish());
                    continue block60;
                }
                case Swahili: {
                    this.registerLanguage(new Swahili());
                    continue block60;
                }
                case Swedish: {
                    this.registerLanguage(new Swedish());
                    continue block60;
                }
                case Tagalog: {
                    this.registerLanguage(new Tagalog());
                    continue block60;
                }
                case Thai: {
                    this.registerLanguage(new Thai());
                    continue block60;
                }
                case Turkish: {
                    this.registerLanguage(new Turkish());
                    continue block60;
                }
                case Ukrainian: {
                    this.registerLanguage(new Ukrainian());
                    continue block60;
                }
                case Urdu: {
                    this.registerLanguage(new Urdu());
                    continue block60;
                }
                case Vietnamese: {
                    this.registerLanguage(new Vietnamese());
                    continue block60;
                }
                case Yoruba: {
                    this.registerLanguage(new Yoruba());
                    continue block60;
                }
                case Zulu: {
                    this.registerLanguage(new Zulu());
                    continue block60;
                }
            }
        }
    }

    private void registerLanguage(Language language) {
        this.stopWords.addAll(language.stopWords());
    }
}

