/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.migration;

import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import org.dizitart.no2.Nitrite;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.common.Fields;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.tuples.Quartet;
import org.dizitart.no2.common.tuples.Triplet;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.common.util.SecureString;
import org.dizitart.no2.exceptions.MigrationException;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.dizitart.no2.migration.CustomInstruction;
import org.dizitart.no2.migration.Migration;
import org.dizitart.no2.migration.MigrationStep;
import org.dizitart.no2.migration.TypeConverter;
import org.dizitart.no2.migration.commands.AddField;
import org.dizitart.no2.migration.commands.ChangeDataType;
import org.dizitart.no2.migration.commands.ChangeIdField;
import org.dizitart.no2.migration.commands.Command;
import org.dizitart.no2.migration.commands.CreateIndex;
import org.dizitart.no2.migration.commands.DeleteField;
import org.dizitart.no2.migration.commands.Drop;
import org.dizitart.no2.migration.commands.DropIndex;
import org.dizitart.no2.migration.commands.Rename;
import org.dizitart.no2.migration.commands.RenameField;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.StoreMetaData;
import org.dizitart.no2.store.UserAuthenticationService;

public class MigrationManager {
    private final NitriteConfig nitriteConfig;
    private final StoreMetaData storeMetadata;
    private final Nitrite database;

    public MigrationManager(Nitrite nitrite) {
        this.database = nitrite;
        this.nitriteConfig = nitrite.getConfig();
        this.storeMetadata = nitrite.getDatabaseMetaData();
    }

    public void doMigrate() {
        if (this.isMigrationNeeded()) {
            boolean hasValidPath;
            Integer currentVersion = this.storeMetadata.getSchemaVersion();
            Integer targetVersion = this.nitriteConfig.getSchemaVersion();
            Queue<Migration> migrationPath = this.findMigrationPath(currentVersion, targetVersion);
            boolean bl = hasValidPath = migrationPath != null && !migrationPath.isEmpty();
            if (!hasValidPath) {
                this.closeDatabaseAndThrowException(currentVersion, targetVersion);
            }
            this.executeMigrationPath(migrationPath);
        }
    }

    private void closeDatabaseAndThrowException(Integer currentVersion, Integer targetVersion) {
        try {
            this.database.close();
        }
        catch (Exception e) {
            throw new NitriteIOException("Failed to close the database", e);
        }
        throw new MigrationException("Schema version mismatch, no migration path found from version " + currentVersion + " to " + targetVersion);
    }

    private void executeMigrationPath(Queue<Migration> migrationPath) {
        int pathLength = migrationPath.size();
        for (int i = 0; i < pathLength; ++i) {
            Migration migration = migrationPath.poll();
            if (migration == null) continue;
            Queue<MigrationStep> migrationSteps = migration.steps();
            this.executeMigrationSteps(migrationSteps);
        }
    }

    private boolean isMigrationNeeded() {
        Integer existingVersion = this.storeMetadata.getSchemaVersion();
        Integer incomingVersion = this.nitriteConfig.getSchemaVersion();
        if (existingVersion == null) {
            throw new MigrationException("Corrupted database, no version information found");
        }
        if (incomingVersion == null) {
            throw new MigrationException("Invalid version provided");
        }
        return !existingVersion.equals(incomingVersion);
    }

    private Queue<Migration> findMigrationPath(int start, int end) {
        if (start == end) {
            return new LinkedList<Migration>();
        }
        boolean migrateUp = end > start;
        return this.findUpMigrationPath(migrateUp, start, end);
    }

    private Queue<Migration> findUpMigrationPath(boolean upgrade, int start, int end) {
        LinkedList<Migration> result = new LinkedList<Migration>();
        while (upgrade ? start < end : start > end) {
            TreeMap<Integer, Migration> targetNodes = this.nitriteConfig.getMigrations().get(start);
            if (targetNodes == null) {
                return null;
            }
            Set<Integer> keySet = upgrade ? targetNodes.descendingKeySet() : targetNodes.keySet();
            boolean found = false;
            for (int targetVersion : keySet) {
                boolean shouldAddToPath;
                if (upgrade) {
                    shouldAddToPath = targetVersion <= end && targetVersion > start;
                } else {
                    boolean bl = shouldAddToPath = targetVersion >= end && targetVersion < start;
                }
                if (!shouldAddToPath) continue;
                result.offer(targetNodes.get(targetVersion));
                start = targetVersion;
                found = true;
                break;
            }
            if (found) continue;
            return null;
        }
        return result;
    }

    private void executeMigrationSteps(Queue<MigrationStep> migrationSteps) {
        if (migrationSteps != null) {
            int length = migrationSteps.size();
            for (int i = 0; i < length; ++i) {
                MigrationStep step = migrationSteps.poll();
                this.executeStep(step);
            }
        }
        StoreMetaData metaData = this.database.getDatabaseMetaData();
        metaData.setSchemaVersion(this.nitriteConfig.getSchemaVersion());
        NitriteMap<String, Document> storeInfo = this.database.getStore().openMap("$nitrite_store_info", String.class, Document.class);
        storeInfo.put("$nitrite_store_info", metaData.getInfo());
    }

    private void executeStep(MigrationStep step) {
        if (step != null) {
            Command command = null;
            switch (step.getInstructionType()) {
                case AddUser: {
                    Pair arg1 = (Pair)step.getArguments();
                    command = nitrite -> {
                        UserAuthenticationService authService = new UserAuthenticationService(nitrite.getStore());
                        authService.addOrUpdatePassword(false, (String)arg1.getFirst(), null, (SecureString)arg1.getSecond());
                    };
                    break;
                }
                case ChangePassword: {
                    Triplet arg2 = (Triplet)step.getArguments();
                    command = nitrite -> {
                        UserAuthenticationService authService = new UserAuthenticationService(nitrite.getStore());
                        authService.addOrUpdatePassword(true, (String)arg2.getFirst(), (SecureString)arg2.getSecond(), (SecureString)arg2.getThird());
                    };
                    break;
                }
                case DropCollection: {
                    String arg3 = (String)step.getArguments();
                    command = new Drop(arg3);
                    break;
                }
                case DropRepository: {
                    Pair arg4 = (Pair)step.getArguments();
                    command = new Drop(ObjectUtils.findRepositoryName((String)arg4.getFirst(), (String)arg4.getSecond()));
                    break;
                }
                case Custom: {
                    CustomInstruction instruction = (CustomInstruction)step.getArguments();
                    command = instruction::perform;
                    break;
                }
                case CollectionRename: {
                    Pair arg5 = (Pair)step.getArguments();
                    command = new Rename((String)arg5.getFirst(), (String)arg5.getSecond());
                    break;
                }
                case CollectionAddField: {
                    Triplet arg6 = (Triplet)step.getArguments();
                    command = new AddField((String)arg6.getFirst(), (String)arg6.getSecond(), arg6.getThird());
                    break;
                }
                case CollectionRenameField: {
                    Triplet arg7 = (Triplet)step.getArguments();
                    command = new RenameField((String)arg7.getFirst(), (String)arg7.getSecond(), (String)arg7.getThird());
                    break;
                }
                case CollectionDeleteField: {
                    Pair arg8 = (Pair)step.getArguments();
                    command = new DeleteField((String)arg8.getFirst(), (String)arg8.getSecond());
                    break;
                }
                case CollectionDropIndex: {
                    Pair arg9 = (Pair)step.getArguments();
                    command = new DropIndex((String)arg9.getFirst(), (Fields)arg9.getSecond());
                    break;
                }
                case CollectionDropIndices: {
                    String collectionName = (String)step.getArguments();
                    command = new DropIndex(collectionName, null);
                    break;
                }
                case CollectionCreateIndex: {
                    Triplet arg10 = (Triplet)step.getArguments();
                    command = new CreateIndex((String)arg10.getFirst(), (Fields)arg10.getSecond(), (String)arg10.getThird());
                    break;
                }
                case RenameRepository: {
                    Quartet arg11 = (Quartet)step.getArguments();
                    String repositoryName = ObjectUtils.findRepositoryName((String)arg11.getFirst(), (String)arg11.getSecond());
                    String newRepositoryName = ObjectUtils.findRepositoryName((String)arg11.getThird(), (String)arg11.getFourth());
                    command = new Rename(repositoryName, newRepositoryName);
                    break;
                }
                case RepositoryAddField: {
                    Quartet arg13 = (Quartet)step.getArguments();
                    command = new AddField(ObjectUtils.findRepositoryName((String)arg13.getFirst(), (String)arg13.getSecond()), (String)arg13.getThird(), arg13.getFourth());
                    break;
                }
                case RepositoryRenameField: {
                    Quartet arg14 = (Quartet)step.getArguments();
                    command = new RenameField(ObjectUtils.findRepositoryName((String)arg14.getFirst(), (String)arg14.getSecond()), (String)arg14.getThird(), (String)arg14.getFourth());
                    break;
                }
                case RepositoryDeleteField: {
                    Triplet arg15 = (Triplet)step.getArguments();
                    command = new DeleteField(ObjectUtils.findRepositoryName((String)arg15.getFirst(), (String)arg15.getSecond()), (String)arg15.getThird());
                    break;
                }
                case RepositoryChangeDataType: {
                    Quartet arg16 = (Quartet)step.getArguments();
                    command = new ChangeDataType(ObjectUtils.findRepositoryName((String)arg16.getFirst(), (String)arg16.getSecond()), (String)arg16.getThird(), (TypeConverter)arg16.getFourth());
                    break;
                }
                case RepositoryChangeIdField: {
                    Quartet arg17 = (Quartet)step.getArguments();
                    command = new ChangeIdField(ObjectUtils.findRepositoryName((String)arg17.getFirst(), (String)arg17.getSecond()), (Fields)arg17.getThird(), (Fields)arg17.getFourth());
                    break;
                }
                case RepositoryDropIndex: {
                    Triplet arg18 = (Triplet)step.getArguments();
                    command = new DropIndex(ObjectUtils.findRepositoryName((String)arg18.getFirst(), (String)arg18.getSecond()), (Fields)arg18.getThird());
                    break;
                }
                case RepositoryDropIndices: {
                    Pair arg19 = (Pair)step.getArguments();
                    command = new DropIndex(ObjectUtils.findRepositoryName((String)arg19.getFirst(), (String)arg19.getSecond()), null);
                    break;
                }
                case RepositoryCreateIndex: {
                    Quartet arg20 = (Quartet)step.getArguments();
                    command = new CreateIndex(ObjectUtils.findRepositoryName((String)arg20.getFirst(), (String)arg20.getSecond()), (Fields)arg20.getThird(), (String)arg20.getFourth());
                }
            }
            command.execute(this.database);
            command.close();
        }
    }
}

