/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.repository;

import java.lang.reflect.Field;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.DocumentCursor;
import org.dizitart.no2.collection.FindOptions;
import org.dizitart.no2.collection.NitriteCollection;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.mapper.NitriteMapper;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.common.util.StringUtils;
import org.dizitart.no2.exceptions.InvalidIdException;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.exceptions.NotIdentifiableException;
import org.dizitart.no2.exceptions.ObjectMappingException;
import org.dizitart.no2.exceptions.ValidationException;
import org.dizitart.no2.filters.ComparableFilter;
import org.dizitart.no2.filters.EqualsFilter;
import org.dizitart.no2.filters.FieldBasedFilter;
import org.dizitart.no2.filters.Filter;
import org.dizitart.no2.filters.NitriteFilter;
import org.dizitart.no2.repository.AnnotationScanner;
import org.dizitart.no2.repository.Cursor;
import org.dizitart.no2.repository.EntityDecorator;
import org.dizitart.no2.repository.EntityDecoratorScanner;
import org.dizitart.no2.repository.ObjectCursor;
import org.dizitart.no2.repository.ObjectIdField;

public class RepositoryOperations {
    private final NitriteConfig nitriteConfig;
    private final NitriteMapper nitriteMapper;
    private final NitriteCollection collection;
    private final Class<?> type;
    private AnnotationScanner annotationScanner;
    private ObjectIdField objectIdField;
    private EntityDecoratorScanner entityDecoratorScanner;

    public RepositoryOperations(Class<?> type, NitriteCollection collection, NitriteConfig nitriteConfig) {
        this.type = type;
        this.nitriteConfig = nitriteConfig;
        this.nitriteMapper = nitriteConfig.nitriteMapper();
        this.collection = collection;
        this.annotationScanner = new AnnotationScanner(type, collection, this.nitriteMapper);
        this.validateCollection();
    }

    public RepositoryOperations(EntityDecorator<?> entityDecorator, NitriteCollection collection, NitriteConfig nitriteConfig) {
        this.type = entityDecorator.getEntityType();
        this.nitriteConfig = nitriteConfig;
        this.nitriteMapper = nitriteConfig.nitriteMapper();
        this.collection = collection;
        this.entityDecoratorScanner = new EntityDecoratorScanner(entityDecorator, collection, this.nitriteMapper);
        this.validateCollection();
    }

    public void scanIndexes() {
        if (this.annotationScanner != null) {
            this.annotationScanner.performScan();
            this.objectIdField = this.annotationScanner.getObjectIdField();
        } else if (this.entityDecoratorScanner != null) {
            this.entityDecoratorScanner.readEntity();
            this.objectIdField = this.entityDecoratorScanner.getObjectIdField();
        }
    }

    public void createIndexes() {
        if (this.annotationScanner != null) {
            this.annotationScanner.createIndices();
            this.annotationScanner.createIdIndex();
        } else if (this.entityDecoratorScanner != null) {
            this.entityDecoratorScanner.createIndices();
            this.entityDecoratorScanner.createIdIndex();
        }
    }

    public void serializeFields(Document document) {
        if (document != null) {
            for (Pair pair : document) {
                String key = (String)pair.getFirst();
                Object value = pair.getSecond();
                Object serializedValue = this.nitriteMapper.tryConvert(value, Document.class);
                document.put(key, serializedValue);
            }
        }
    }

    public <T> Document[] toDocuments(T[] others) {
        if (others == null || others.length == 0) {
            return null;
        }
        Document[] documents = new Document[others.length];
        for (int i = 0; i < others.length; ++i) {
            documents[i] = this.toDocument(others[i], false);
        }
        return documents;
    }

    public <T> Document toDocument(T object, boolean update) {
        Document document = (Document)this.nitriteMapper.tryConvert(object, Document.class);
        if (document == null) {
            throw new ObjectMappingException("Failed to map object to document");
        }
        if (this.objectIdField != null) {
            Object idValue;
            Field idField = this.objectIdField.getField();
            if (idField.getType() == NitriteId.class) {
                try {
                    idField.setAccessible(true);
                    if (idField.get(object) == null) {
                        NitriteId id = document.getId();
                        idField.set(object, id);
                        document.put(this.objectIdField.getIdFieldName(), this.nitriteMapper.tryConvert(id, Comparable.class));
                    } else if (!update) {
                        throw new InvalidIdException("Auto generated id should not be set manually");
                    }
                }
                catch (IllegalAccessException iae) {
                    throw new InvalidIdException("Auto generated id value cannot be accessed");
                }
            }
            if ((idValue = document.get(this.objectIdField.getIdFieldName())) == null) {
                throw new InvalidIdException("Id cannot be null");
            }
            if (idValue instanceof String && StringUtils.isNullOrEmpty((String)idValue)) {
                throw new InvalidIdException("Id value cannot be empty string");
            }
        }
        return document;
    }

    public Filter createUniqueFilter(Object object) {
        if (this.objectIdField == null) {
            throw new NotIdentifiableException("No id value found for the object");
        }
        Field idField = this.objectIdField.getField();
        idField.setAccessible(true);
        try {
            Object value = idField.get(object);
            if (value == null) {
                throw new InvalidIdException("Id value cannot be null");
            }
            return this.objectIdField.createUniqueFilter(value, this.nitriteMapper);
        }
        catch (IllegalAccessException iae) {
            throw new InvalidIdException("Id field is not accessible");
        }
    }

    public void removeNitriteId(Document document) {
        Field idField;
        document.remove("_id");
        if (this.objectIdField != null && (idField = this.objectIdField.getField()) != null && !this.objectIdField.isEmbedded() && idField.getType() == NitriteId.class) {
            document.remove(idField.getName());
        }
    }

    public <I> Filter createIdFilter(I id) {
        if (this.objectIdField != null) {
            if (id == null) {
                throw new InvalidIdException("Id cannot be null");
            }
            if (!ObjectUtils.isCompatibleTypes(id.getClass(), this.objectIdField.getField().getType())) {
                throw new InvalidIdException("A value of invalid type is provided as id");
            }
            return this.objectIdField.createUniqueFilter(id, this.nitriteMapper);
        }
        throw new NotIdentifiableException(this.type.getName() + " does not have any id field");
    }

    public Filter asObjectFilter(Filter filter) {
        if (filter instanceof NitriteFilter) {
            NitriteFilter nitriteFilter = (NitriteFilter)filter;
            nitriteFilter.setObjectFilter(true);
            nitriteFilter.setNitriteConfig(this.nitriteConfig);
            if (filter instanceof FieldBasedFilter) {
                return this.createObjectFilter((FieldBasedFilter)filter);
            }
            return nitriteFilter;
        }
        return filter;
    }

    public <T> Cursor<T> find(Filter filter, FindOptions findOptions, Class<T> type) {
        DocumentCursor documentCursor = this.collection.find(this.asObjectFilter(filter), findOptions);
        return new ObjectCursor<T>(this.nitriteMapper, documentCursor, type);
    }

    private void validateCollection() {
        if (this.collection == null) {
            throw new ValidationException("Repository has not been initialized properly");
        }
    }

    private Filter createObjectFilter(FieldBasedFilter fieldBasedFilter) {
        if (this.objectIdField != null && this.objectIdField.getIdFieldName().equals(fieldBasedFilter.getField())) {
            Object fieldValue;
            Object converted;
            if (fieldBasedFilter instanceof EqualsFilter) {
                return this.objectIdField.createUniqueFilter(fieldBasedFilter.getValue(), this.nitriteMapper);
            }
            if (fieldBasedFilter instanceof ComparableFilter && (converted = this.nitriteMapper.tryConvert(fieldValue = fieldBasedFilter.getValue(), Document.class)) instanceof Document) {
                throw new InvalidOperationException("Cannot compare object of type " + String.valueOf(fieldValue.getClass()));
            }
        }
        return fieldBasedFilter;
    }
}

