/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.store;

import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.common.event.NitriteEventBus;
import org.dizitart.no2.store.NitriteStore;
import org.dizitart.no2.store.StoreCatalog;
import org.dizitart.no2.store.StoreConfig;
import org.dizitart.no2.store.events.EventInfo;
import org.dizitart.no2.store.events.StoreEventBus;
import org.dizitart.no2.store.events.StoreEventListener;
import org.dizitart.no2.store.events.StoreEvents;

public abstract class AbstractNitriteStore<Config extends StoreConfig>
implements NitriteStore<Config> {
    private Config storeConfig;
    protected final NitriteEventBus<EventInfo, StoreEventListener> eventBus = new StoreEventBus();
    protected NitriteConfig nitriteConfig;
    private StoreCatalog storeCatalog;

    protected AbstractNitriteStore() {
    }

    protected void alert(StoreEvents eventType) {
        EventInfo event = new EventInfo(eventType, this.nitriteConfig);
        this.eventBus.post(event);
    }

    @Override
    public Set<String> getCollectionNames() {
        return this.getCatalog().getCollectionNames();
    }

    @Override
    public Set<String> getRepositoryRegistry() {
        return this.getCatalog().getRepositoryNames();
    }

    @Override
    public Map<String, Set<String>> getKeyedRepositoryRegistry() {
        return this.getCatalog().getKeyedRepositoryNames();
    }

    @Override
    public void beforeClose() {
        this.alert(StoreEvents.Closing);
    }

    @Override
    public String subscribe(StoreEventListener listener) {
        return this.eventBus.register(listener);
    }

    @Override
    public void unsubscribe(String subscription) {
        this.eventBus.deregister(subscription);
    }

    @Override
    public void initialize(NitriteConfig nitriteConfig) {
        this.nitriteConfig = nitriteConfig;
    }

    @Override
    public StoreCatalog getCatalog() {
        if (this.storeCatalog == null) {
            this.storeCatalog = new StoreCatalog(this);
        }
        return this.storeCatalog;
    }

    @Override
    @Generated
    public Config getStoreConfig() {
        return this.storeConfig;
    }

    @Generated
    public NitriteEventBus<EventInfo, StoreEventListener> getEventBus() {
        return this.eventBus;
    }

    @Generated
    public NitriteConfig getNitriteConfig() {
        return this.nitriteConfig;
    }

    @Generated
    public StoreCatalog getStoreCatalog() {
        return this.storeCatalog;
    }

    @Generated
    public void setStoreConfig(Config storeConfig) {
        this.storeConfig = storeConfig;
    }
}

