/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.store.memory;

import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dizitart.no2.common.RecordStream;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.util.Comparables;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteStore;

public class InMemoryMap<Key, Value>
implements NitriteMap<Key, Value> {
    private final NavigableMap<Key, Value> backingMap;
    private final NitriteStore<?> nitriteStore;
    private final String mapName;
    private final AtomicBoolean droppedFlag;
    private final AtomicBoolean closedFlag;

    public InMemoryMap(String mapName, NitriteStore<?> nitriteStore) {
        this.mapName = mapName;
        this.nitriteStore = nitriteStore;
        this.backingMap = new ConcurrentSkipListMap<Key, Value>((o1, o2) -> Comparables.compare((Comparable)o1, (Comparable)o2));
        this.closedFlag = new AtomicBoolean(false);
        this.droppedFlag = new AtomicBoolean(false);
    }

    @Override
    public boolean containsKey(Key key) {
        this.checkOpened();
        return this.backingMap.containsKey(key);
    }

    @Override
    public Value get(Key key) {
        this.checkOpened();
        return (Value)this.backingMap.get(key);
    }

    @Override
    public NitriteStore<?> getStore() {
        return this.nitriteStore;
    }

    @Override
    public String getName() {
        return this.mapName;
    }

    @Override
    public RecordStream<Value> values() {
        this.checkOpened();
        return RecordStream.fromIterable(this.backingMap.values());
    }

    @Override
    public Value remove(Key key) {
        this.checkOpened();
        Object value = this.backingMap.remove(key);
        this.updateLastModifiedTime();
        return (Value)value;
    }

    @Override
    public RecordStream<Key> keys() {
        this.checkOpened();
        return RecordStream.fromIterable(this.backingMap.keySet());
    }

    @Override
    public void put(Key key, Value value) {
        this.checkOpened();
        ValidationUtils.notNull(value, "value cannot be null");
        this.backingMap.put(key, value);
        this.updateLastModifiedTime();
    }

    @Override
    public long size() {
        this.checkOpened();
        return this.backingMap.size();
    }

    @Override
    public Value putIfAbsent(Key key, Value value) {
        this.checkOpened();
        ValidationUtils.notNull(value, "value cannot be null");
        Value v = this.get(key);
        if (v == null) {
            this.put(key, value);
            this.updateLastModifiedTime();
        }
        return v;
    }

    @Override
    public RecordStream<Pair<Key, Value>> entries() {
        this.checkOpened();
        return this.getStream(this.backingMap);
    }

    @Override
    public RecordStream<Pair<Key, Value>> reversedEntries() {
        this.checkOpened();
        return this.getStream(this.backingMap.descendingMap());
    }

    @Override
    public Key firstKey() {
        this.checkOpened();
        return (Key)this.backingMap.firstKey();
    }

    @Override
    public Key lastKey() {
        this.checkOpened();
        return (Key)this.backingMap.lastKey();
    }

    @Override
    public Key higherKey(Key key) {
        this.checkOpened();
        if (key == null) {
            return null;
        }
        return this.backingMap.higherKey(key);
    }

    @Override
    public Key ceilingKey(Key key) {
        this.checkOpened();
        if (key == null) {
            return null;
        }
        return this.backingMap.ceilingKey(key);
    }

    @Override
    public Key lowerKey(Key key) {
        this.checkOpened();
        if (key == null) {
            return null;
        }
        return this.backingMap.lowerKey(key);
    }

    @Override
    public Key floorKey(Key key) {
        this.checkOpened();
        if (key == null) {
            return null;
        }
        return this.backingMap.floorKey(key);
    }

    @Override
    public boolean isEmpty() {
        this.checkOpened();
        return this.backingMap.isEmpty();
    }

    @Override
    public void drop() {
        if (!this.droppedFlag.get()) {
            this.backingMap.clear();
            this.getStore().removeMap(this.mapName);
            this.droppedFlag.compareAndSet(false, true);
            this.closedFlag.compareAndSet(false, true);
        }
    }

    @Override
    public boolean isDropped() {
        return this.droppedFlag.get();
    }

    @Override
    public void close() {
        this.closedFlag.compareAndSet(false, true);
        this.getStore().closeMap(this.mapName);
    }

    @Override
    public boolean isClosed() {
        return this.closedFlag.get();
    }

    @Override
    public void clear() {
        this.checkOpened();
        this.backingMap.clear();
        this.getStore().closeMap(this.mapName);
        this.updateLastModifiedTime();
    }

    private RecordStream<Pair<Key, Value>> getStream(final NavigableMap<Key, Value> primaryMap) {
        return RecordStream.fromIterable(() -> new Iterator<Pair<Key, Value>>(){
            private final Iterator entryIterator;
            {
                this.entryIterator = primaryMap.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryIterator.hasNext();
            }

            @Override
            public Pair<Key, Value> next() {
                Map.Entry entry = (Map.Entry)this.entryIterator.next();
                return new Pair(entry.getKey(), entry.getValue());
            }
        });
    }

    private void checkOpened() {
        if (this.closedFlag.get()) {
            throw new InvalidOperationException("Map " + this.mapName + " is closed");
        }
        if (this.droppedFlag.get()) {
            throw new InvalidOperationException("Map " + this.mapName + " is dropped");
        }
    }
}

