/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.store.memory;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.RecordStream;
import org.dizitart.no2.common.util.SpatialKey;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.index.BoundingBox;
import org.dizitart.no2.store.NitriteRTree;
import org.dizitart.no2.store.NitriteStore;

public class InMemoryRTree<Key extends BoundingBox, Value>
implements NitriteRTree<Key, Value> {
    private final Map<SpatialKey, Key> backingMap = new ConcurrentHashMap<SpatialKey, Key>();
    private final AtomicBoolean droppedFlag;
    private final AtomicBoolean closedFlag = new AtomicBoolean(false);
    private final String mapName;
    private final NitriteStore<?> nitriteStore;

    public InMemoryRTree(String mapName, NitriteStore<?> nitriteStore) {
        this.droppedFlag = new AtomicBoolean(false);
        this.mapName = mapName;
        this.nitriteStore = nitriteStore;
    }

    @Override
    public void add(Key key, NitriteId nitriteId) {
        this.checkOpened();
        if (nitriteId != null) {
            SpatialKey spatialKey = this.getKey(key, nitriteId.getIdValue());
            this.backingMap.put(spatialKey, key);
        }
    }

    @Override
    public void remove(Key key, NitriteId nitriteId) {
        this.checkOpened();
        if (nitriteId != null) {
            SpatialKey spatialKey = this.getKey(key, nitriteId.getIdValue());
            this.backingMap.remove(spatialKey);
        }
    }

    @Override
    public RecordStream<NitriteId> findIntersectingKeys(Key key) {
        this.checkOpened();
        SpatialKey spatialKey = this.getKey(key, 0L);
        HashSet<NitriteId> set = new HashSet<NitriteId>();
        for (SpatialKey sk : this.backingMap.keySet()) {
            if (!this.isOverlap(sk, spatialKey)) continue;
            set.add(NitriteId.createId(Long.toString(sk.getId())));
        }
        return RecordStream.fromIterable(set);
    }

    @Override
    public RecordStream<NitriteId> findContainedKeys(Key key) {
        this.checkOpened();
        SpatialKey spatialKey = this.getKey(key, 0L);
        HashSet<NitriteId> set = new HashSet<NitriteId>();
        for (SpatialKey sk : this.backingMap.keySet()) {
            if (!this.isInside(sk, spatialKey)) continue;
            set.add(NitriteId.createId(Long.toString(sk.getId())));
        }
        return RecordStream.fromIterable(set);
    }

    @Override
    public long size() {
        this.checkOpened();
        return this.backingMap.size();
    }

    @Override
    public void close() {
        this.closedFlag.compareAndSet(false, true);
    }

    @Override
    public void clear() {
        this.checkOpened();
        this.backingMap.clear();
    }

    @Override
    public void drop() {
        this.checkOpened();
        this.droppedFlag.compareAndSet(false, true);
        this.backingMap.clear();
        this.nitriteStore.removeRTree(this.mapName);
    }

    private SpatialKey getKey(Key key, long id) {
        if (key == null || ((BoundingBox)key).equals(BoundingBox.EMPTY)) {
            return new SpatialKey(id, new float[0]);
        }
        return new SpatialKey(id, ((BoundingBox)key).getMinX(), ((BoundingBox)key).getMaxX(), ((BoundingBox)key).getMinY(), ((BoundingBox)key).getMaxY());
    }

    private boolean isOverlap(SpatialKey a, SpatialKey b) {
        if (a.isNull() || b.isNull()) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            if (!(a.max(i) < b.min(i)) && !(a.min(i) > b.max(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isInside(SpatialKey a, SpatialKey b) {
        if (a.isNull() || b.isNull()) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            if (!(a.min(i) <= b.min(i)) && !(a.max(i) >= b.max(i))) continue;
            return false;
        }
        return true;
    }

    private void checkOpened() {
        if (this.closedFlag.get()) {
            throw new InvalidOperationException("RTreeMap is closed");
        }
        if (this.droppedFlag.get()) {
            throw new InvalidOperationException("RTreeMap is dropped");
        }
    }
}

