/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.Generated;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.DocumentCursor;
import org.dizitart.no2.collection.FindOptions;
import org.dizitart.no2.collection.NitriteCollection;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.collection.UpdateOptions;
import org.dizitart.no2.collection.events.CollectionEventInfo;
import org.dizitart.no2.collection.events.CollectionEventListener;
import org.dizitart.no2.collection.operation.CollectionOperations;
import org.dizitart.no2.common.WriteResult;
import org.dizitart.no2.common.event.EventBus;
import org.dizitart.no2.common.event.NitriteEventBus;
import org.dizitart.no2.common.meta.Attributes;
import org.dizitart.no2.common.processors.Processor;
import org.dizitart.no2.common.util.DocumentUtils;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.exceptions.IndexingException;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.dizitart.no2.exceptions.NotIdentifiableException;
import org.dizitart.no2.exceptions.TransactionException;
import org.dizitart.no2.filters.Filter;
import org.dizitart.no2.index.IndexDescriptor;
import org.dizitart.no2.index.IndexOptions;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteStore;
import org.dizitart.no2.transaction.ChangeType;
import org.dizitart.no2.transaction.JournalEntry;
import org.dizitart.no2.transaction.TransactionConfig;
import org.dizitart.no2.transaction.TransactionContext;

class DefaultTransactionalCollection
implements NitriteCollection {
    private final NitriteCollection primary;
    private final TransactionContext transactionContext;
    private String collectionName;
    private NitriteMap<NitriteId, Document> nitriteMap;
    private NitriteStore<?> nitriteStore;
    private CollectionOperations collectionOperations;
    private volatile boolean isDropped;
    private volatile boolean isClosed;
    private Lock writeLock;
    private Lock readLock;
    private EventBus<CollectionEventInfo<?>, CollectionEventListener> eventBus;

    public DefaultTransactionalCollection(NitriteCollection primary, TransactionContext transactionContext) {
        this.primary = primary;
        this.transactionContext = transactionContext;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteResult insert(Document[] documents) {
        WriteResult result;
        ValidationUtils.notNull(documents, "a null document cannot be inserted");
        ValidationUtils.containsNull(documents, "a null document cannot be inserted");
        for (Document document : documents) {
            document.getId();
        }
        try {
            this.writeLock.lock();
            this.checkOpened();
            result = this.collectionOperations.insert(documents);
        }
        finally {
            this.writeLock.unlock();
        }
        JournalEntry journalEntry = new JournalEntry();
        journalEntry.setChangeType(ChangeType.Insert);
        journalEntry.setCommit(() -> this.primary.insert(documents));
        journalEntry.setRollback(() -> {
            for (Document document : documents) {
                this.primary.remove(document);
            }
        });
        this.transactionContext.getJournal().add(journalEntry);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteResult update(Filter filter, Document update, UpdateOptions updateOptions) {
        WriteResult result;
        ValidationUtils.notNull(update, "a null document cannot be used for update");
        ValidationUtils.notNull(updateOptions, "updateOptions cannot be null");
        try {
            this.writeLock.lock();
            this.checkOpened();
            result = this.collectionOperations.update(filter, update, updateOptions);
        }
        finally {
            this.writeLock.unlock();
        }
        ArrayList documentList = new ArrayList();
        JournalEntry journalEntry = new JournalEntry();
        journalEntry.setChangeType(ChangeType.Update);
        journalEntry.setCommit(() -> {
            DocumentCursor cursor = this.primary.find(filter);
            if (!cursor.isEmpty()) {
                if (updateOptions.isJustOnce()) {
                    documentList.add((Document)cursor.firstOrNull());
                } else {
                    documentList.addAll(cursor.toList());
                }
            }
            this.primary.update(filter, update, updateOptions);
        });
        journalEntry.setRollback(() -> {
            for (Document document : documentList) {
                this.primary.remove(document);
                this.primary.insert(document, new Document[0]);
            }
        });
        this.transactionContext.getJournal().add(journalEntry);
        return result;
    }

    @Override
    public WriteResult update(Document document, boolean insertIfAbsent) {
        ValidationUtils.notNull(document, "a null document cannot be used for update");
        if (insertIfAbsent) {
            return this.update(DocumentUtils.createUniqueFilter(document), document, UpdateOptions.updateOptions(true));
        }
        if (document.hasId()) {
            return this.update(DocumentUtils.createUniqueFilter(document), document, UpdateOptions.updateOptions(false));
        }
        throw new NotIdentifiableException("Update operation failed as no id value found for the document");
    }

    @Override
    public WriteResult remove(Document document) {
        WriteResult result;
        ValidationUtils.notNull(document, "A null document cannot be removed");
        if (document.hasId()) {
            try {
                this.writeLock.lock();
                this.checkOpened();
                result = this.collectionOperations.remove(document);
            }
            finally {
                this.writeLock.unlock();
            }
        } else {
            throw new NotIdentifiableException("Remove operation failed as no id value found for the document");
        }
        AtomicReference toRemove = new AtomicReference();
        JournalEntry journalEntry = new JournalEntry();
        journalEntry.setChangeType(ChangeType.Remove);
        journalEntry.setCommit(() -> {
            toRemove.set(this.primary.getById(document.getId()));
            this.primary.remove(document);
        });
        journalEntry.setRollback(() -> {
            if (toRemove.get() != null) {
                this.primary.insert((Document)toRemove.get(), new Document[0]);
            }
        });
        this.transactionContext.getJournal().add(journalEntry);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteResult remove(Filter filter, boolean justOne) {
        WriteResult result;
        if ((filter == null || filter == Filter.ALL) && justOne) {
            throw new InvalidOperationException("Remove all cannot be combined with just once");
        }
        try {
            this.writeLock.lock();
            this.checkOpened();
            result = this.collectionOperations.remove(filter, justOne);
        }
        finally {
            this.writeLock.unlock();
        }
        JournalEntry journalEntry = this.getJournalEntry(filter, justOne);
        this.transactionContext.getJournal().add(journalEntry);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentCursor find(Filter filter, FindOptions findOptions) {
        try {
            this.readLock.lock();
            this.checkOpened();
            DocumentCursor documentCursor = this.collectionOperations.find(filter, findOptions);
            return documentCursor;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Document getById(NitriteId nitriteId) {
        ValidationUtils.notNull(nitriteId, "nitriteId cannot be null");
        try {
            this.readLock.lock();
            this.checkOpened();
            Document document = this.collectionOperations.getById(nitriteId);
            return document;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getName() {
        return this.collectionName;
    }

    @Override
    public void addProcessor(Processor processor) {
        ValidationUtils.notNull(processor, "a null processor cannot be added");
        try {
            this.writeLock.lock();
            this.checkOpened();
            this.collectionOperations.addProcessor(processor);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void createIndex(IndexOptions indexOptions, String ... fieldNames) {
        try {
            this.writeLock.lock();
            this.checkOpened();
            this.primary.createIndex(indexOptions, fieldNames);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rebuildIndex(String ... fieldNames) {
        try {
            this.writeLock.lock();
            this.checkOpened();
            this.primary.rebuildIndex(fieldNames);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Collection<IndexDescriptor> listIndices() {
        try {
            this.readLock.lock();
            this.checkOpened();
            Collection<IndexDescriptor> collection = this.primary.listIndices();
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean hasIndex(String ... fieldNames) {
        try {
            this.readLock.lock();
            this.checkOpened();
            boolean bl = this.primary.hasIndex(fieldNames);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isIndexing(String ... fieldNames) {
        try {
            this.readLock.lock();
            this.checkOpened();
            boolean bl = this.primary.isIndexing(fieldNames);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void dropIndex(String ... fieldNames) {
        try {
            this.writeLock.lock();
            this.checkOpened();
            this.primary.dropIndex(fieldNames);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void dropAllIndices() {
        try {
            this.writeLock.lock();
            this.checkOpened();
            this.primary.dropAllIndices();
            this.collectionOperations.initialize();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void clear() {
        try {
            this.writeLock.lock();
            this.checkOpened();
            this.primary.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void drop() {
        try {
            this.writeLock.lock();
            this.checkOpened();
            this.primary.drop();
        }
        finally {
            this.close();
            this.writeLock.unlock();
        }
        this.isDropped = true;
    }

    @Override
    public boolean isDropped() {
        return this.isDropped;
    }

    @Override
    public boolean isOpen() {
        if (this.nitriteStore == null || this.nitriteStore.isClosed() || this.isDropped) {
            try {
                this.close();
            }
            catch (Exception e) {
                throw new NitriteIOException("Failed to close the collection", e);
            }
            return false;
        }
        return true;
    }

    @Override
    public synchronized void close() {
        if (this.collectionOperations != null) {
            this.collectionOperations.close();
        }
        this.closeEventBus();
        this.isClosed = true;
    }

    @Override
    public long size() {
        return this.find().size();
    }

    @Override
    public NitriteStore<?> getStore() {
        return this.nitriteStore;
    }

    @Override
    public String subscribe(CollectionEventListener listener) {
        ValidationUtils.notNull(listener, "listener cannot be null");
        try {
            this.writeLock.lock();
            this.checkOpened();
            String string = this.eventBus.register(listener);
            return string;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void unsubscribe(String subscription) {
        ValidationUtils.notNull(subscription, "subscription cannot be null");
        try {
            this.writeLock.lock();
            this.checkOpened();
            if (this.eventBus != null) {
                this.eventBus.deregister(subscription);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Attributes getAttributes() {
        try {
            this.readLock.lock();
            this.checkOpened();
            Attributes attributes = this.collectionOperations.getAttributes();
            return attributes;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setAttributes(Attributes attributes) {
        ValidationUtils.notNull(attributes, "attributes cannot be null");
        try {
            this.writeLock.lock();
            this.checkOpened();
            this.collectionOperations.setAttributes(attributes);
        }
        finally {
            this.writeLock.unlock();
        }
        AtomicReference original = new AtomicReference();
        JournalEntry journalEntry = new JournalEntry();
        journalEntry.setChangeType(ChangeType.SetAttributes);
        journalEntry.setCommit(() -> {
            original.set(this.primary.getAttributes());
            this.primary.setAttributes(attributes);
        });
        journalEntry.setRollback(() -> {
            if (original.get() != null) {
                this.primary.setAttributes((Attributes)original.get());
            }
        });
        this.transactionContext.getJournal().add(journalEntry);
    }

    private void initialize() {
        this.collectionName = this.transactionContext.getCollectionName();
        this.nitriteMap = this.transactionContext.getNitriteMap();
        this.isDropped = false;
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.readLock = rwLock.readLock();
        this.writeLock = rwLock.writeLock();
        this.eventBus = new CollectionEventBus();
        this.initializeOperation();
    }

    private void initializeOperation() {
        TransactionConfig nitriteConfig = this.transactionContext.getConfig();
        this.nitriteStore = nitriteConfig.getNitriteStore();
        this.collectionOperations = new CollectionOperations(this.collectionName, this.nitriteMap, nitriteConfig, this.eventBus);
    }

    private JournalEntry getJournalEntry(Filter filter, boolean justOne) {
        ArrayList documentList = new ArrayList();
        JournalEntry journalEntry = new JournalEntry();
        journalEntry.setChangeType(ChangeType.Remove);
        journalEntry.setCommit(() -> {
            DocumentCursor cursor = this.primary.find(filter);
            if (!cursor.isEmpty()) {
                if (justOne) {
                    documentList.add((Document)cursor.firstOrNull());
                } else {
                    documentList.addAll(cursor.toList());
                }
            }
            this.primary.remove(filter, justOne);
        });
        journalEntry.setRollback(() -> {
            for (Document document : documentList) {
                this.primary.insert(document, new Document[0]);
            }
        });
        return journalEntry;
    }

    private void checkOpened() {
        if (this.isClosed) {
            throw new TransactionException("Collection is closed");
        }
        if (!this.primary.isOpen()) {
            throw new TransactionException("Store is closed");
        }
        if (this.isDropped()) {
            throw new TransactionException("Collection is dropped");
        }
        if (!this.transactionContext.getActive().get()) {
            throw new TransactionException("Transaction is not active");
        }
    }

    private void closeEventBus() {
        if (this.eventBus != null) {
            this.eventBus.close();
        }
        this.eventBus = null;
    }

    private void validateRebuildIndex(IndexDescriptor indexDescriptor) {
        ValidationUtils.notNull(indexDescriptor, "indexDescriptor cannot be null");
        String[] fieldNames = indexDescriptor.getFields().getFieldNames().toArray(new String[0]);
        if (this.isIndexing(fieldNames)) {
            throw new IndexingException("Indexing on fields " + String.valueOf(indexDescriptor.getFields()) + " is currently running");
        }
    }

    @Generated
    public NitriteCollection getPrimary() {
        return this.primary;
    }

    @Generated
    public TransactionContext getTransactionContext() {
        return this.transactionContext;
    }

    @Generated
    public String getCollectionName() {
        return this.collectionName;
    }

    @Generated
    public NitriteMap<NitriteId, Document> getNitriteMap() {
        return this.nitriteMap;
    }

    @Generated
    public NitriteStore<?> getNitriteStore() {
        return this.nitriteStore;
    }

    @Generated
    public CollectionOperations getCollectionOperations() {
        return this.collectionOperations;
    }

    @Generated
    public boolean isClosed() {
        return this.isClosed;
    }

    @Generated
    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    @Generated
    public void setNitriteMap(NitriteMap<NitriteId, Document> nitriteMap) {
        this.nitriteMap = nitriteMap;
    }

    @Generated
    public void setNitriteStore(NitriteStore<?> nitriteStore) {
        this.nitriteStore = nitriteStore;
    }

    @Generated
    public void setCollectionOperations(CollectionOperations collectionOperations) {
        this.collectionOperations = collectionOperations;
    }

    @Generated
    public void setDropped(boolean isDropped) {
        this.isDropped = isDropped;
    }

    @Generated
    public void setClosed(boolean isClosed) {
        this.isClosed = isClosed;
    }

    private static class CollectionEventBus
    extends NitriteEventBus<CollectionEventInfo<?>, CollectionEventListener> {
        private CollectionEventBus() {
        }

        @Override
        public void post(CollectionEventInfo<?> collectionEventInfo) {
            for (CollectionEventListener listener : this.getListeners()) {
                this.getEventExecutor().submit(() -> listener.onEvent(collectionEventInfo));
            }
        }
    }
}

