/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.transaction;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dizitart.no2.Nitrite;
import org.dizitart.no2.common.concurrent.LockService;
import org.dizitart.no2.exceptions.TransactionException;
import org.dizitart.no2.transaction.NitriteTransaction;
import org.dizitart.no2.transaction.Transaction;
import org.dizitart.no2.transaction.TransactionState;

public class Session
implements AutoCloseable {
    private final Nitrite nitrite;
    private final AtomicBoolean active;
    private final LockService lockService;
    private final Map<String, Transaction> transactionMap;

    public Session(Nitrite nitrite, LockService lockService) {
        this.nitrite = nitrite;
        this.active = new AtomicBoolean(true);
        this.lockService = lockService;
        this.transactionMap = new HashMap<String, Transaction>();
    }

    public Transaction beginTransaction() {
        this.checkState();
        NitriteTransaction tx = new NitriteTransaction(this.nitrite, this.lockService);
        this.transactionMap.put(tx.getId(), tx);
        return tx;
    }

    @Override
    public void close() {
        this.active.compareAndSet(true, false);
        for (Transaction transaction : this.transactionMap.values()) {
            if (transaction.getState() == TransactionState.Closed) continue;
            transaction.rollback();
        }
    }

    public void checkState() {
        if (!this.active.get()) {
            throw new TransactionException("Session is closed");
        }
    }
}

