/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.transaction;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.transaction.JournalEntry;
import org.dizitart.no2.transaction.TransactionConfig;

class TransactionContext
implements AutoCloseable {
    private String collectionName;
    private Queue<JournalEntry> journal;
    private NitriteMap<NitriteId, Document> nitriteMap;
    private TransactionConfig config;
    private AtomicBoolean active = new AtomicBoolean(true);

    @Override
    public void close() throws Exception {
        this.journal.clear();
        this.nitriteMap.clear();
        this.nitriteMap.close();
        this.active.compareAndSet(true, false);
    }

    @Generated
    public String getCollectionName() {
        return this.collectionName;
    }

    @Generated
    public Queue<JournalEntry> getJournal() {
        return this.journal;
    }

    @Generated
    public NitriteMap<NitriteId, Document> getNitriteMap() {
        return this.nitriteMap;
    }

    @Generated
    public TransactionConfig getConfig() {
        return this.config;
    }

    @Generated
    public AtomicBoolean getActive() {
        return this.active;
    }

    @Generated
    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    @Generated
    public void setJournal(Queue<JournalEntry> journal) {
        this.journal = journal;
    }

    @Generated
    public void setNitriteMap(NitriteMap<NitriteId, Document> nitriteMap) {
        this.nitriteMap = nitriteMap;
    }

    @Generated
    public void setConfig(TransactionConfig config) {
        this.config = config;
    }

    @Generated
    public void setActive(AtomicBoolean active) {
        this.active = active;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionContext)) {
            return false;
        }
        TransactionContext other = (TransactionContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        if (this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName)) {
            return false;
        }
        Queue<JournalEntry> this$journal = this.getJournal();
        Queue<JournalEntry> other$journal = other.getJournal();
        if (this$journal == null ? other$journal != null : !this$journal.equals(other$journal)) {
            return false;
        }
        NitriteMap<NitriteId, Document> this$nitriteMap = this.getNitriteMap();
        NitriteMap<NitriteId, Document> other$nitriteMap = other.getNitriteMap();
        if (this$nitriteMap == null ? other$nitriteMap != null : !this$nitriteMap.equals(other$nitriteMap)) {
            return false;
        }
        TransactionConfig this$config = this.getConfig();
        TransactionConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        AtomicBoolean this$active = this.getActive();
        AtomicBoolean other$active = other.getActive();
        return !(this$active == null ? other$active != null : !this$active.equals(other$active));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransactionContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        Queue<JournalEntry> $journal = this.getJournal();
        result = result * 59 + ($journal == null ? 43 : $journal.hashCode());
        NitriteMap<NitriteId, Document> $nitriteMap = this.getNitriteMap();
        result = result * 59 + ($nitriteMap == null ? 43 : $nitriteMap.hashCode());
        TransactionConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        AtomicBoolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : $active.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionContext(collectionName=" + this.getCollectionName() + ", journal=" + String.valueOf(this.getJournal()) + ", nitriteMap=" + String.valueOf(this.getNitriteMap()) + ", config=" + String.valueOf(this.getConfig()) + ", active=" + String.valueOf(this.getActive()) + ")";
    }
}

