/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.transaction;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dizitart.no2.exceptions.InvalidOperationException;
import org.dizitart.no2.index.BoundingBox;
import org.dizitart.no2.store.AbstractNitriteStore;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteRTree;
import org.dizitart.no2.store.NitriteStore;
import org.dizitart.no2.store.StoreConfig;
import org.dizitart.no2.store.events.StoreEventListener;
import org.dizitart.no2.transaction.TransactionalMap;
import org.dizitart.no2.transaction.TransactionalRTree;

class TransactionStore<T extends StoreConfig>
extends AbstractNitriteStore<T> {
    private final NitriteStore<T> primaryStore;
    private final Map<String, NitriteMap<?, ?>> mapRegistry;
    private final Map<String, NitriteRTree<?, ?>> rTreeRegistry;
    private final List<String> deletedMap = new ArrayList<String>();

    public TransactionStore(NitriteStore<T> store) {
        this.primaryStore = store;
        this.mapRegistry = new ConcurrentHashMap();
        this.rTreeRegistry = new ConcurrentHashMap();
    }

    @Override
    public void openOrCreate() {
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public boolean hasUnsavedChanges() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void commit() {
        throw new InvalidOperationException("Call commit on transaction");
    }

    @Override
    public void close() {
        for (NitriteMap<?, ?> nitriteMap : this.mapRegistry.values()) {
            nitriteMap.close();
        }
        for (NitriteRTree nitriteRTree : this.rTreeRegistry.values()) {
            nitriteRTree.close();
        }
        this.mapRegistry.clear();
        this.rTreeRegistry.clear();
        this.eventBus.close();
    }

    @Override
    public boolean hasMap(String mapName) {
        if (this.deletedMap.contains(mapName)) {
            return false;
        }
        boolean result = this.primaryStore.hasMap(mapName);
        if (!result && !(result = this.mapRegistry.containsKey(mapName))) {
            return this.rTreeRegistry.containsKey(mapName);
        }
        return true;
    }

    @Override
    public <Key, Value> NitriteMap<Key, Value> openMap(String mapName, Class<?> keyType, Class<?> valueType) {
        if (this.mapRegistry.containsKey(mapName)) {
            NitriteMap<?, ?> nitriteMap = this.mapRegistry.get(mapName);
            if (nitriteMap.isClosed()) {
                this.mapRegistry.remove(mapName);
            } else {
                return nitriteMap;
            }
        }
        NitriteMap primaryMap = null;
        if (this.primaryStore.hasMap(mapName)) {
            primaryMap = this.primaryStore.openMap(mapName, keyType, valueType);
        }
        TransactionalMap transactionalMap = new TransactionalMap(mapName, primaryMap, this);
        this.mapRegistry.put(mapName, transactionalMap);
        return transactionalMap;
    }

    @Override
    public <Key extends BoundingBox, Value> NitriteRTree<Key, Value> openRTree(String rTreeName, Class<?> keyType, Class<?> valueType) {
        if (this.rTreeRegistry.containsKey(rTreeName)) {
            return this.rTreeRegistry.get(rTreeName);
        }
        NitriteRTree primaryMap = null;
        if (this.primaryStore.hasMap(rTreeName)) {
            primaryMap = this.primaryStore.openRTree(rTreeName, keyType, valueType);
        }
        TransactionalRTree transactionalRtree = new TransactionalRTree(primaryMap);
        this.rTreeRegistry.put(rTreeName, transactionalRtree);
        return transactionalRtree;
    }

    @Override
    public void closeMap(String mapName) {
        this.mapRegistry.remove(mapName);
    }

    @Override
    public void closeRTree(String rTreeName) {
        this.rTreeRegistry.remove(rTreeName);
    }

    @Override
    public void removeMap(String mapName) {
        this.mapRegistry.remove(mapName);
        this.deletedMap.add(mapName);
    }

    @Override
    public void removeRTree(String rTreeName) {
        this.rTreeRegistry.remove(rTreeName);
        this.deletedMap.add(rTreeName);
    }

    @Override
    public String subscribe(StoreEventListener listener) {
        return null;
    }

    @Override
    public void unsubscribe(String subscription) {
    }

    @Override
    public String getStoreVersion() {
        return this.primaryStore.getStoreVersion();
    }

    @Override
    public T getStoreConfig() {
        return null;
    }
}

