/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.base;

public final class AngleUtil {
    public static final double PI2 = Math.PI * 2;

    private AngleUtil() {
    }

    public static double normalizeAroundPi(double angle) {
        return angle - Math.PI * 2 * Math.floor(angle / (Math.PI * 2));
    }

    public static double normalizeAroundZero(double angle) {
        return angle + Math.PI * 2 * Math.floor((-angle + Math.PI) / (Math.PI * 2));
    }

    public static boolean epsilonEquals(double angle1, double angle2, double epsilon) {
        if (Math.abs(angle1 - angle2) < epsilon) {
            return true;
        }
        double diff = Math.abs(AngleUtil.normalizeAroundZero(angle2) - AngleUtil.normalizeAroundZero(angle1));
        return diff < epsilon || Math.abs(Math.PI * 2 - diff) < epsilon;
    }

    public static double interpolateClockwise(double angle1, double angle2, double fraction) {
        double a1 = AngleUtil.normalizeAroundPi(angle1);
        double a2 = AngleUtil.normalizeAroundPi(angle2);
        if (a2 < a1) {
            a2 += Math.PI * 2;
        }
        return AngleUtil.normalizeAroundZero((1.0 - fraction) * a1 + fraction * a2);
    }

    public static double interpolateShortest(double angle1, double angle2, double fraction) {
        double result;
        if (fraction == 1.0) {
            result = angle2;
        } else {
            double difference = angle2 - angle1;
            if (difference < -Math.PI) {
                difference -= Math.PI * 2 * Math.ceil((difference - Math.PI) / (Math.PI * 2));
            }
            if (difference > Math.PI) {
                difference -= Math.PI * 2 * Math.floor((difference + Math.PI) / (Math.PI * 2));
            }
            result = angle1 + fraction * difference;
        }
        return AngleUtil.normalizeAroundZero(result);
    }
}

