/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.complex;

public class Complex {
    public final double re;
    public final double im;
    public static final Complex ZERO = new Complex(0.0, 0.0);
    public static final Complex ONE = new Complex(1.0, 0.0);
    public static final Complex MINUS_ONE = new Complex(-1.0, 0.0);
    public static final Complex I = new Complex(0.0, 1.0);
    public static final Complex MINUS_I = new Complex(0.0, -1.0);
    private static final double EPSILONSQRT = Math.sqrt(Math.ulp(1.0) / 2.0);
    private static final double SQRT_OF_MIN_VALUE = Math.sqrt(Double.MIN_VALUE);
    private static final double SQRT_OF_MAX_VALUE = Math.sqrt(Double.MAX_VALUE);

    public Complex(double re, double im) {
        this.re = re;
        this.im = im;
    }

    public Complex(double re) {
        this.re = re;
        this.im = 0.0;
    }

    public double getRe() {
        return this.re;
    }

    public double getIm() {
        return this.im;
    }

    public double norm() {
        return Complex.hypot(this.re, this.im);
    }

    public static double hypot(double x, double y) {
        if (x != x || y != y) {
            return Double.NaN;
        }
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        if (absX == Double.POSITIVE_INFINITY || absY == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (absX < absY) {
            double swap = absX;
            absX = absY;
            absY = swap;
        }
        if (absY <= absX * EPSILONSQRT) {
            return absX;
        }
        double scale = SQRT_OF_MIN_VALUE;
        if (absX > SQRT_OF_MAX_VALUE) {
            absX *= scale;
            absY *= scale;
            scale = 1.0 / scale;
        } else if (absY < SQRT_OF_MIN_VALUE) {
            absX /= scale;
            absY /= scale;
        } else {
            scale = 1.0;
        }
        double h = Math.sqrt(Math.fma(absX, absX, absY * absY));
        double hsq = h * h;
        double xsq = absX * absX;
        double a = Math.fma(-absY, absY, hsq - xsq) + Math.fma(h, h, -hsq) - Math.fma(absX, absX, -xsq);
        return scale * (h - a / (2.0 * h));
    }

    public double phi() {
        return Math.atan2(this.im, this.re);
    }

    public boolean isReal() {
        return this.im == 0.0;
    }

    public boolean isImaginary() {
        return this.re == 0.0;
    }

    public Complex conjugate() {
        return new Complex(this.re, -this.im);
    }

    public Complex rotate(double angle) {
        double sin = Math.sin(angle);
        double cos = Math.cos(angle);
        return new Complex(this.re * cos - this.im * sin, this.im * cos + this.re * sin);
    }

    public Complex plus(Complex rightOperand) {
        return new Complex(this.re + rightOperand.re, this.im + rightOperand.im);
    }

    public Complex plus(double rightOperand) {
        return new Complex(this.re + rightOperand, this.im);
    }

    public Complex minus(Complex rightOperand) {
        return new Complex(this.re - rightOperand.re, this.im - rightOperand.im);
    }

    public Complex minus(double rightOperand) {
        return new Complex(this.re - rightOperand, this.im);
    }

    public Complex times(Complex rightOperand) {
        return new Complex(this.re * rightOperand.re - this.im * rightOperand.im, this.im * rightOperand.re + this.re * rightOperand.im);
    }

    public Complex times(double rightOperand) {
        return new Complex(this.re * rightOperand, this.im * rightOperand);
    }

    public Complex reciprocal() {
        double divisor = this.re * this.re + this.im * this.im;
        if (0.0 == divisor) {
            return new Complex(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        return new Complex(this.re / divisor, -this.im / divisor);
    }

    public Complex divideBy(Complex rightOperand) {
        if (rightOperand.re == 0.0 && rightOperand.im == 0.0) {
            return new Complex(this.re / 0.0, this.im / 0.0);
        }
        return this.times(rightOperand.reciprocal());
    }

    public Complex divideBy(double rightOperand) {
        return new Complex(this.re / rightOperand, this.im / rightOperand);
    }

    public String toString() {
        return "Complex [re=" + this.re + ", im=" + this.im + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.im);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.re);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Complex other = (Complex)obj;
        if (Double.doubleToLongBits(this.im) != Double.doubleToLongBits(other.im)) {
            return false;
        }
        return Double.doubleToLongBits(this.re) == Double.doubleToLongBits(other.re);
    }
}

