/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.complex;

import org.djutils.base.AngleUtil;
import org.djutils.complex.Complex;

public final class ComplexMath {
    private static final Complex MAXIMUM = new Complex(Double.MAX_VALUE, Double.MAX_VALUE);

    private ComplexMath() {
    }

    public static Complex sqrt(Complex z) {
        double norm = z.norm();
        return new Complex(Math.sqrt((z.re + norm) / 2.0), (double)(z.im >= 0.0 ? 1 : -1) * Math.sqrt((-z.re + norm) / 2.0));
    }

    public static Complex cbrt(Complex z) {
        double cbrtOfNorm = Math.cbrt(z.norm());
        double phi = z.phi() / 3.0;
        return new Complex(cbrtOfNorm * Math.cos(phi), cbrtOfNorm * Math.sin(phi));
    }

    public static Complex exp(Complex z) {
        double factor = Math.exp(z.re);
        return new Complex(factor * Math.cos(z.im), factor * Math.sin(z.im));
    }

    public static Complex ln(Complex z) {
        return new Complex(Math.log(z.norm()), z.phi());
    }

    public static Complex sin(Complex z) {
        return new Complex(Math.sin(z.re) * Math.cosh(z.im), Math.cos(z.re) * Math.sinh(z.im));
    }

    public static Complex cos(Complex z) {
        return new Complex(Math.cos(z.re) * Math.cosh(z.im), -Math.sin(z.re) * Math.sinh(z.im));
    }

    public static Complex tan(Complex z) {
        double divisor = Math.cos(2.0 * z.re) + Math.cosh(2.0 * z.im);
        return new Complex(Math.sin(2.0 * z.re) / divisor, Math.sinh(2.0 * z.im) / divisor);
    }

    public static Complex sinh(Complex z) {
        return new Complex(Math.sinh(z.re) * Math.cos(z.im), Math.cosh(z.re) * Math.sin(z.im));
    }

    public static Complex cosh(Complex z) {
        return new Complex(Math.cosh(z.re) * Math.cos(z.im), Math.sinh(z.re) * Math.sin(z.im));
    }

    public static Complex tanh(Complex z) {
        double re2 = z.re * 2.0;
        double im2 = z.im * 2.0;
        double divisor = Math.cosh(re2) + Math.cos(im2);
        return new Complex(Math.sinh(re2) / divisor, Math.sin(im2) / divisor);
    }

    public static Complex asin(Complex z) {
        Complex ct = z.times(Complex.I);
        Complex zz = new Complex((z.re - z.im) * (z.re + z.im), 2.0 * z.re * z.im);
        zz = new Complex(1.0 - zz.re, -zz.im);
        zz = ct.plus(ComplexMath.sqrt(zz));
        zz = ComplexMath.ln(zz);
        return zz.times(Complex.MINUS_I);
    }

    public static Complex acos(Complex z) {
        Complex asin = ComplexMath.asin(z);
        return new Complex(1.5707963267948966 - asin.re, -asin.im);
    }

    public static Complex atan(Complex z) {
        if (z.re == 0.0 && z.im > 1.0) {
            return MAXIMUM;
        }
        double x2 = z.re * z.re;
        double a = 1.0 - x2 - z.im * z.im;
        if (a == 0.0) {
            return MAXIMUM;
        }
        double re = AngleUtil.normalizeAroundZero(Math.atan2(2.0 * z.re, a)) / 2.0;
        double t = z.im - 1.0;
        a = x2 + t * t;
        if (a == 0.0) {
            return MAXIMUM;
        }
        t = z.im + 1.0;
        a = (x2 + t * t) / a;
        return new Complex(re, 0.25 * Math.log(a));
    }

    public static Complex asinh(Complex z) {
        return Complex.MINUS_I.times(ComplexMath.asin(z.times(Complex.I)));
    }

    public static Complex acosh(Complex z) {
        return ComplexMath.ln(z.plus(ComplexMath.sqrt(z.plus(Complex.ONE)).times(ComplexMath.sqrt(z.minus(Complex.ONE)))));
    }

    public static Complex atanh(Complex z) {
        return Complex.MINUS_I.times(ComplexMath.atan(z.times(Complex.I)));
    }
}

