/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.decoderdumper;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.djutils.decoderdumper.CharDecoder;
import org.djutils.decoderdumper.Decoder;
import org.djutils.decoderdumper.Dumper;
import org.djutils.decoderdumper.FixedString;
import org.djutils.decoderdumper.HexDecoder;
import org.djutils.logger.CategoryLogger;

public class Base64Decoder
implements Decoder {
    private int notYetDecodedData = 0;
    private int accumulatedBits = 0;
    private final Dumper<Base64Decoder> internalDumper = new Dumper();
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private int endOfInputCharsSeen = 0;
    private boolean errorDetected = false;

    public Base64Decoder(int decodedBytesPerLine, int extraSpaceAfterEvery) {
        this.internalDumper.setOutputStream(this.baos);
        int maximumBytesPerOutputLine = (decodedBytesPerLine + 3) / 4 * 3;
        this.internalDumper.addDecoder(new HexDecoder(maximumBytesPerOutputLine, extraSpaceAfterEvery));
        this.internalDumper.addDecoder(new FixedString("  "));
        this.internalDumper.addDecoder(new CharDecoder(maximumBytesPerOutputLine, extraSpaceAfterEvery));
    }

    @Override
    public String getResult() {
        try {
            this.internalDumper.flush();
            String result = this.baos.toString("UTF-8");
            this.baos.reset();
            return result;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    public int getMaximumWidth() {
        return this.internalDumper.getMaximumWidth();
    }

    @Override
    public boolean append(int address, byte theByte) throws IOException {
        int value;
        if (theByte == 61) {
            ++this.endOfInputCharsSeen;
        }
        if (this.endOfInputCharsSeen > 0) {
            return false;
        }
        if (theByte >= 48 && theByte <= 57) {
            value = theByte - 48 + 52;
        } else if (theByte >= 65 && theByte <= 90) {
            value = theByte - 65 + 0;
        } else if (theByte >= 97 && theByte <= 122) {
            value = theByte - 97 + 26;
        } else if (theByte == 43 || theByte == 45 || theByte == 46) {
            value = 62;
        } else if (theByte == 47 || theByte == 95 || theByte == 44) {
            value = 63;
        } else {
            if (theByte <= 32) {
                return false;
            }
            if (!this.errorDetected) {
                CategoryLogger.always().info("illegal character found in Base64Decoder stream at address {}, character {}", address, theByte);
            }
            this.errorDetected = true;
            return false;
        }
        this.notYetDecodedData = (this.notYetDecodedData << 6) + value;
        this.accumulatedBits += 6;
        if (this.accumulatedBits >= 8) {
            int byteValue = this.notYetDecodedData >> this.accumulatedBits - 8;
            this.accumulatedBits -= 8;
            this.notYetDecodedData -= byteValue << this.accumulatedBits;
            boolean result = this.internalDumper.append((byte)byteValue);
            return result;
        }
        return false;
    }

    @Override
    public boolean ignoreForIdenticalOutputCheck() {
        return false;
    }
}

