/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.decoderdumper;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.djutils.decoderdumper.Decoder;

public class Dumper<T> {
    private List<Decoder> decoders = new ArrayList<Decoder>();
    private int address = 0;
    private OutputStream outputStream = System.out;
    private boolean suppressMultipleIdenticalLines = false;
    private int suppressedCount = 0;
    private String lastPattern = "";
    private String lastOutput = "";
    private static final String SUPPRESSEDOUTPUTINDICATORLINE = "*\n";

    public Dumper(int addressOffset) {
        this.address = addressOffset;
    }

    public Dumper() {
        this(0);
    }

    public Dumper<T> setOutputStream(OutputStream newOutputStream) {
        this.outputStream = newOutputStream;
        return this;
    }

    public Dumper<T> setSuppressMultipleIdenticalLines(boolean newState) {
        this.suppressMultipleIdenticalLines = newState;
        return this;
    }

    public void addDecoder(Decoder decoder) {
        this.decoders.add(decoder);
    }

    public Dumper<T> addDecoder(int index, Decoder decoder) throws IndexOutOfBoundsException {
        this.decoders.add(index, decoder);
        return this;
    }

    private void writeOutput(String outputText) throws IOException {
        this.outputStream.write(outputText.getBytes("UTF-8"));
    }

    private void writeFilteringOutput(String outputText, String pattern) throws IOException {
        if (!(this.suppressedCount <= 0 || this.suppressMultipleIdenticalLines && pattern.equals(this.lastPattern))) {
            if (!outputText.equals(this.lastPattern)) {
                this.writeOutput(this.lastOutput);
            }
            this.suppressedCount = 0;
        }
        this.lastOutput = outputText;
        if (!this.suppressMultipleIdenticalLines || !pattern.equals(this.lastPattern)) {
            this.writeOutput(outputText);
        } else if (1 == this.suppressedCount++) {
            this.writeOutput(SUPPRESSEDOUTPUTINDICATORLINE);
        }
        this.lastPattern = pattern;
    }

    public boolean append(byte theByte) throws IOException {
        boolean needFlush = false;
        for (Decoder decoder : this.decoders) {
            needFlush |= decoder.append(this.address, theByte);
        }
        ++this.address;
        if (needFlush) {
            return this.flush();
        }
        return false;
    }

    public Dumper<T> append(byte[] bytes) throws IOException {
        return this.append(bytes, 0, bytes.length);
    }

    public Dumper<T> append(byte[] bytes, int start, int len) throws IOException {
        for (int pos = start; pos < start + len; ++pos) {
            this.append(bytes[pos]);
        }
        return this;
    }

    public Dumper<T> append(InputStream inputStream) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        while ((read = inputStream.read(buffer)) >= 0) {
            this.append(buffer, 0, read);
        }
        return this;
    }

    public boolean flush() throws IOException {
        StringBuilder result = new StringBuilder();
        StringBuilder pattern = new StringBuilder();
        int totalReturnedWidth = 0;
        for (Decoder decoder : this.decoders) {
            String part = decoder.getResult();
            totalReturnedWidth += part.length();
            if (part.length() < decoder.getMaximumWidth()) {
                String format = String.format("%%-%ds", decoder.getMaximumWidth());
                part = String.format(format, part);
            }
            result.append(part);
            if (decoder.ignoreForIdenticalOutputCheck()) continue;
            pattern.append(part);
        }
        this.writeFilteringOutput(totalReturnedWidth == 0 ? "" : result.toString(), pattern.toString());
        return totalReturnedWidth > 0;
    }

    public int getMaximumWidth() {
        int result = 0;
        for (Decoder decoder : this.decoders) {
            result += decoder.getMaximumWidth();
        }
        return result;
    }

    public String toString() {
        return "Dumper [decoders=" + this.decoders + ", address=" + this.address + ", outputStream=" + this.outputStream + ", suppressMultipleIdenticalLines=" + this.suppressMultipleIdenticalLines + ", suppressedCount=" + this.suppressedCount + ", lastPattern=" + this.lastPattern + "]";
    }
}

