/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.event;

import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.djutils.event.Event;
import org.djutils.event.EventListener;
import org.djutils.event.EventListenerMap;
import org.djutils.event.EventType;
import org.djutils.event.TimedEvent;
import org.djutils.event.reference.Reference;
import org.djutils.event.reference.ReferenceType;
import org.djutils.event.reference.StrongReference;
import org.djutils.event.reference.WeakReference;
import org.djutils.exceptions.Throw;

public interface EventProducer
extends Serializable,
Remote {
    public static final int FIRST_POSITION = 0;
    public static final int LAST_POSITION = -1;

    default public boolean addListener(EventListener listener, EventType eventType, int position, ReferenceType referenceType) throws RemoteException {
        Throw.whenNull(listener, "listener cannot be null");
        Throw.whenNull(eventType, "eventType cannot be null");
        Throw.whenNull(referenceType, "referenceType cannot be null");
        if (position < -1) {
            return false;
        }
        Reference reference = null;
        reference = referenceType.isStrong() ? new StrongReference<EventListener>(listener) : new WeakReference<EventListener>(listener);
        EventListenerMap eventListenerMap = this.getEventListenerMap();
        if (eventListenerMap.containsKey(eventType)) {
            for (Reference<EventListener> entry : eventListenerMap.get(eventType)) {
                if (!listener.equals(entry.get())) continue;
                return false;
            }
            List<Reference<EventListener>> entries = eventListenerMap.get(eventType);
            if (position == -1) {
                entries.add(reference);
            } else {
                entries.add(position, reference);
            }
        } else {
            ArrayList<Reference<EventListener>> entries = new ArrayList<Reference<EventListener>>();
            entries.add(reference);
            eventListenerMap.put(eventType, entries);
        }
        return true;
    }

    default public boolean addListener(EventListener listener, EventType eventType) throws RemoteException {
        return this.addListener(listener, eventType, 0);
    }

    default public boolean addListener(EventListener listener, EventType eventType, ReferenceType referenceType) throws RemoteException {
        return this.addListener(listener, eventType, 0, referenceType);
    }

    default public boolean addListener(EventListener listener, EventType eventType, int position) throws RemoteException {
        return this.addListener(listener, eventType, position, ReferenceType.STRONG);
    }

    public EventListenerMap getEventListenerMap() throws RemoteException;

    default public int removeAllListeners() throws RemoteException {
        int result = this.getEventListenerMap().size();
        this.getEventListenerMap().clear();
        return result;
    }

    default public int removeAllListeners(Class<?> ofClass) throws RemoteException {
        Throw.whenNull(ofClass, "ofClass may not be null");
        int result = 0;
        LinkedHashMap<EventType, Reference<EventListener>> removeMap = new LinkedHashMap<EventType, Reference<EventListener>>();
        for (EventType type : this.getEventListenerMap().keySet()) {
            for (Reference<EventListener> listener : this.getEventListenerMap().get(type)) {
                if (!listener.get().getClass().isAssignableFrom(ofClass)) continue;
                removeMap.put(type, listener);
                ++result;
            }
        }
        for (EventType type : removeMap.keySet()) {
            this.removeListener((EventListener)((Reference)removeMap.get(type)).get(), type);
        }
        return result;
    }

    default public boolean removeListener(EventListener listener, EventType eventType) throws RemoteException {
        Throw.whenNull(listener, "listener may not be null");
        Throw.whenNull(eventType, "eventType may not be null");
        EventListenerMap eventListenerMap = this.getEventListenerMap();
        if (!eventListenerMap.containsKey(eventType)) {
            return false;
        }
        boolean result = false;
        Iterator<Reference<EventListener>> i = eventListenerMap.get(eventType).iterator();
        while (i.hasNext()) {
            Reference<EventListener> reference = i.next();
            EventListener entry = reference.get();
            if (entry == null) {
                i.remove();
            } else if (listener.equals(entry)) {
                i.remove();
                result = true;
            }
            if (eventListenerMap.get(eventType).size() != 0) continue;
            eventListenerMap.remove(eventType);
        }
        return result;
    }

    default public boolean hasListeners() throws RemoteException {
        return !this.getEventListenerMap().isEmpty();
    }

    default public int numberOfListeners(EventType eventType) throws RemoteException {
        if (this.getEventListenerMap().containsKey(eventType)) {
            return this.getEventListenerMap().get(eventType).size();
        }
        return 0;
    }

    default public List<Reference<EventListener>> getListenerReferences(EventType eventType) throws RemoteException {
        ArrayList<Reference<EventListener>> result = new ArrayList<Reference<EventListener>>();
        if (this.getEventListenerMap().get(eventType) != null) {
            result.addAll(this.getEventListenerMap().get(eventType));
        }
        return result;
    }

    default public Set<EventType> getEventTypesWithListeners() throws RemoteException {
        return this.getEventListenerMap().keySet();
    }

    private boolean removeListener(Reference<EventListener> reference, EventType eventType) throws RemoteException {
        Throw.whenNull(reference, "reference may not be null");
        Throw.whenNull(eventType, "eventType may not be null");
        EventListenerMap eventListenerMap = this.getEventListenerMap();
        boolean success = false;
        Iterator<Reference<EventListener>> i = eventListenerMap.get(eventType).iterator();
        while (i.hasNext()) {
            if (!i.next().equals(reference)) continue;
            i.remove();
            success = true;
        }
        if (eventListenerMap.get(eventType).size() == 0) {
            eventListenerMap.remove(eventType);
        }
        return success;
    }

    default public void fireEvent(Event event) throws RemoteException {
        Throw.whenNull(event, "event may not be null");
        EventListenerMap eventListenerMap = this.getEventListenerMap();
        if (eventListenerMap.containsKey(event.getType())) {
            ArrayList<Reference<EventListener>> listenerList = new ArrayList<Reference<EventListener>>(eventListenerMap.get(event.getType()));
            for (Reference reference : listenerList) {
                EventListener listener = (EventListener)reference.get();
                try {
                    if (listener != null) {
                        this.fireEvent(listener, event);
                        continue;
                    }
                    this.removeListener(reference, event.getType());
                }
                catch (RemoteException remoteException) {
                    this.removeListener(reference, event.getType());
                }
            }
        }
    }

    private void fireEvent(EventListener listener, Event event) throws RemoteException {
        listener.notify(event);
    }

    default public <C extends Comparable<C> & Serializable> void fireTimedEvent(TimedEvent<C> event) throws RemoteException {
        this.fireEvent(event);
    }

    default public void fireEvent(EventType eventType) throws RemoteException {
        this.fireEvent(new Event(eventType, null, true));
    }

    default public <C extends Comparable<C> & Serializable> void fireTimedEvent(EventType eventType, C time) throws RemoteException {
        this.fireEvent(new TimedEvent<C>(eventType, null, time, true));
    }

    default public void fireEvent(EventType eventType, Serializable value) throws RemoteException {
        this.fireEvent(new Event(eventType, value, true));
    }

    default public <C extends Comparable<C> & Serializable> void fireTimedEvent(EventType eventType, Serializable value, C time) throws RemoteException {
        this.fireEvent(new TimedEvent<C>(eventType, value, time, true));
    }

    default public void fireUnverifiedEvent(EventType eventType) throws RemoteException {
        this.fireEvent(new Event(eventType, null, false));
    }

    default public <C extends Comparable<C> & Serializable> void fireUnverifiedTimedEvent(EventType eventType, C time) throws RemoteException {
        this.fireEvent(new TimedEvent<C>(eventType, null, time, false));
    }

    default public void fireUnverifiedEvent(EventType eventType, Serializable value) throws RemoteException {
        this.fireEvent(new Event(eventType, value, false));
    }

    default public <C extends Comparable<C> & Serializable> void fireUnverifiedTimedEvent(EventType eventType, Serializable value, C time) throws RemoteException {
        this.fireEvent(new TimedEvent<C>(eventType, value, time, false));
    }
}

