/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.event;

import java.io.Serializable;
import java.util.Objects;
import org.djutils.exceptions.Throw;
import org.djutils.metadata.MetaData;

public class EventType
implements Serializable {
    private static final long serialVersionUID = 20140830L;
    private final String name;
    private final MetaData metaData;
    private String definingClassName;

    public EventType(String name, MetaData metaData) {
        StackTraceElement[] steArray;
        Throw.when(name == null || name.equals(""), IllegalArgumentException.class, "EventType name == null || EventType name == \"\"");
        Throw.whenNull(metaData, "Meta data may not be null (but you could provide the NO_META_DATA value if the payload will be varying)");
        this.name = name;
        for (StackTraceElement ste : steArray = new Throwable().getStackTrace()) {
            if (ste.getClassName().endsWith("EventType")) continue;
            this.definingClassName = ste.getClassName();
            break;
        }
        Throw.whenNull(this.definingClassName, "no defining class name found that is not an EventType");
        this.metaData = metaData;
    }

    public EventType(MetaData metaData) {
        this(metaData == null ? null : metaData.getName(), metaData);
    }

    @Deprecated
    public EventType(String name) {
        this(name, MetaData.NO_META_DATA);
    }

    public String getName() {
        return this.name;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public int hashCode() {
        return Objects.hash(this.definingClassName, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventType other = (EventType)obj;
        return Objects.equals(this.definingClassName, other.definingClassName) && Objects.equals(this.name, other.name);
    }

    public String toString() {
        return this.name;
    }
}

