/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.event.collection;

import java.rmi.RemoteException;
import java.util.Collection;
import org.djutils.event.Event;
import org.djutils.event.EventListener;
import org.djutils.event.EventType;
import org.djutils.event.LocalEventProducer;
import org.djutils.event.collection.EventProducingIterator;
import org.djutils.event.reference.ReferenceType;
import org.djutils.exceptions.Throw;
import org.djutils.metadata.MetaData;
import org.djutils.metadata.ObjectDescriptor;

public class EventProducingCollection<T>
extends LocalEventProducer
implements EventListener,
Collection<T> {
    private static final long serialVersionUID = 20191230L;
    public static final EventType OBJECT_ADDED_EVENT = new EventType("OBJECT_ADDED_EVENT", new MetaData("Size of the collection after add", "Size of the collection", new ObjectDescriptor("Size of the collection after add", "Size of the collection", Integer.class)));
    public static final EventType OBJECT_REMOVED_EVENT = new EventType("OBJECT_REMOVED_EVENT", new MetaData("Size of the collection after remove", "Size of the collection", new ObjectDescriptor("Size of the collection after remove", "Size of the collection", Integer.class)));
    public static final EventType OBJECT_CHANGED_EVENT = new EventType("OBJECT_CHANGED_EVENT", new MetaData("Size of the collection after change", "Size of the collection", new ObjectDescriptor("Size of the collection after change", "Size of the collection", Integer.class)));
    private final Collection<T> wrappedCollection;

    public EventProducingCollection(Collection<T> wrappedCollection) {
        Throw.whenNull(wrappedCollection, "wrappedCollection cannot be null");
        this.wrappedCollection = wrappedCollection;
    }

    @Override
    public int size() {
        return this.wrappedCollection.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedCollection.isEmpty();
    }

    @Override
    public void clear() {
        int nr = this.wrappedCollection.size();
        this.wrappedCollection.clear();
        if (nr != this.wrappedCollection.size()) {
            this.fireEvent(OBJECT_REMOVED_EVENT, Integer.valueOf(this.wrappedCollection.size()));
        }
    }

    @Override
    public boolean add(T o) {
        boolean changed = this.wrappedCollection.add(o);
        if (changed) {
            this.fireEvent(OBJECT_ADDED_EVENT, Integer.valueOf(this.wrappedCollection.size()));
        } else {
            this.fireEvent(OBJECT_CHANGED_EVENT, Integer.valueOf(this.wrappedCollection.size()));
        }
        return changed;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean changed = this.wrappedCollection.addAll(c);
        if (changed) {
            this.fireEvent(OBJECT_ADDED_EVENT, Integer.valueOf(this.wrappedCollection.size()));
        } else if (!c.isEmpty()) {
            this.fireEvent(OBJECT_CHANGED_EVENT, Integer.valueOf(this.wrappedCollection.size()));
        }
        return changed;
    }

    @Override
    public boolean contains(Object o) {
        return this.wrappedCollection.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.wrappedCollection.containsAll(c);
    }

    @Override
    public EventProducingIterator<T> iterator() {
        EventProducingIterator<T> iterator = new EventProducingIterator<T>(this.wrappedCollection.iterator());
        iterator.addListener((EventListener)this, EventProducingIterator.OBJECT_REMOVED_EVENT, ReferenceType.WEAK);
        return iterator;
    }

    @Override
    public void notify(Event event) throws RemoteException {
        if (event.getType().equals(EventProducingIterator.OBJECT_REMOVED_EVENT)) {
            this.fireEvent(OBJECT_REMOVED_EVENT, Integer.valueOf(this.wrappedCollection.size()));
        }
    }

    @Override
    public boolean remove(Object o) {
        boolean changed = this.wrappedCollection.remove(o);
        if (changed) {
            this.fireEvent(OBJECT_REMOVED_EVENT, Integer.valueOf(this.wrappedCollection.size()));
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = this.wrappedCollection.removeAll(c);
        if (changed) {
            this.fireEvent(OBJECT_REMOVED_EVENT, Integer.valueOf(this.wrappedCollection.size()));
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = this.wrappedCollection.retainAll(c);
        if (changed) {
            this.fireEvent(OBJECT_REMOVED_EVENT, Integer.valueOf(this.wrappedCollection.size()));
        }
        return changed;
    }

    @Override
    public Object[] toArray() {
        return this.wrappedCollection.toArray();
    }

    @Override
    public <E> E[] toArray(E[] a) {
        return this.wrappedCollection.toArray(a);
    }
}

