/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.event.collection;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.List;
import org.djutils.event.Event;
import org.djutils.event.EventListener;
import org.djutils.event.EventType;
import org.djutils.event.LocalEventProducer;
import org.djutils.event.collection.EventProducingIterator;
import org.djutils.event.collection.EventProducingListIterator;
import org.djutils.event.reference.ReferenceType;
import org.djutils.exceptions.Throw;
import org.djutils.metadata.MetaData;
import org.djutils.metadata.ObjectDescriptor;

public class EventProducingList<E>
extends LocalEventProducer
implements EventListener,
List<E> {
    private static final long serialVersionUID = 20191230L;
    public static final EventType OBJECT_ADDED_EVENT = new EventType("OBJECT_ADDED_EVENT", new MetaData("Size of the list after add", "Size of the list", new ObjectDescriptor("Size of the list after add", "Size of the list", Integer.class)));
    public static final EventType OBJECT_REMOVED_EVENT = new EventType("OBJECT_REMOVED_EVENT", new MetaData("Size of the list after remove", "Size of the list", new ObjectDescriptor("Size of the list after remove", "Size of the list", Integer.class)));
    public static final EventType OBJECT_CHANGED_EVENT = new EventType("OBJECT_CHANGED_EVENT", new MetaData("Size of the list after change", "Size of the list", new ObjectDescriptor("Size of the list after change", "Size of the list", Integer.class)));
    private List<E> wrappedList = null;

    public EventProducingList(List<E> wrappedList) {
        Throw.whenNull(wrappedList, "wrappedList cannot be null");
        this.wrappedList = wrappedList;
    }

    @Override
    public int size() {
        return this.wrappedList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedList.isEmpty();
    }

    @Override
    public void clear() {
        int nr = this.wrappedList.size();
        this.wrappedList.clear();
        if (nr != this.wrappedList.size()) {
            this.fireEvent(OBJECT_REMOVED_EVENT, Integer.valueOf(this.wrappedList.size()));
        }
    }

    @Override
    public void add(int index, E element) {
        this.wrappedList.add(index, element);
        this.fireEvent(OBJECT_ADDED_EVENT, Integer.valueOf(this.wrappedList.size()));
    }

    @Override
    public boolean add(E o) {
        boolean result = this.wrappedList.add(o);
        if (result) {
            this.fireEvent(OBJECT_ADDED_EVENT, Integer.valueOf(this.wrappedList.size()));
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = this.wrappedList.addAll(c);
        if (result) {
            this.fireEvent(OBJECT_ADDED_EVENT, Integer.valueOf(this.wrappedList.size()));
        }
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean result = this.wrappedList.addAll(index, c);
        if (result) {
            this.fireEvent(OBJECT_ADDED_EVENT, Integer.valueOf(this.wrappedList.size()));
        }
        return result;
    }

    @Override
    public boolean contains(Object o) {
        return this.wrappedList.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.wrappedList.containsAll(c);
    }

    @Override
    public E get(int index) {
        return this.wrappedList.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.wrappedList.indexOf(o);
    }

    @Override
    public EventProducingIterator<E> iterator() {
        EventProducingIterator<E> iterator = new EventProducingIterator<E>(this.wrappedList.iterator());
        iterator.addListener((EventListener)this, EventProducingIterator.OBJECT_REMOVED_EVENT, ReferenceType.WEAK);
        return iterator;
    }

    @Override
    public EventProducingListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public EventProducingListIterator<E> listIterator(int index) {
        EventProducingListIterator<E> iterator = new EventProducingListIterator<E>(this.wrappedList.listIterator(index));
        iterator.addListener((EventListener)this, EventProducingIterator.OBJECT_REMOVED_EVENT, ReferenceType.WEAK);
        iterator.addListener((EventListener)this, EventProducingListIterator.OBJECT_ADDED_EVENT, ReferenceType.WEAK);
        iterator.addListener((EventListener)this, EventProducingListIterator.OBJECT_CHANGED_EVENT, ReferenceType.WEAK);
        return iterator;
    }

    @Override
    public void notify(Event event) throws RemoteException {
        if (event.getType().equals(EventProducingIterator.OBJECT_REMOVED_EVENT)) {
            this.fireEvent(OBJECT_REMOVED_EVENT, Integer.valueOf(this.wrappedList.size()));
        } else if (event.getType().equals(EventProducingListIterator.OBJECT_ADDED_EVENT)) {
            this.fireEvent(OBJECT_ADDED_EVENT, Integer.valueOf(this.wrappedList.size()));
        } else if (event.getType().equals(EventProducingListIterator.OBJECT_CHANGED_EVENT)) {
            this.fireEvent(OBJECT_CHANGED_EVENT, Integer.valueOf(this.wrappedList.size()));
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.wrappedList.lastIndexOf(o);
    }

    @Override
    public E remove(int index) {
        E result = this.wrappedList.remove(index);
        this.fireEvent(OBJECT_REMOVED_EVENT, Integer.valueOf(this.wrappedList.size()));
        return result;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = this.wrappedList.remove(o);
        if (result) {
            this.fireEvent(OBJECT_REMOVED_EVENT, Integer.valueOf(this.wrappedList.size()));
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = this.wrappedList.removeAll(c);
        if (result) {
            this.fireEvent(OBJECT_REMOVED_EVENT, Integer.valueOf(this.wrappedList.size()));
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = this.wrappedList.retainAll(c);
        if (result) {
            this.fireEvent(OBJECT_REMOVED_EVENT, Integer.valueOf(this.wrappedList.size()));
        }
        return result;
    }

    @Override
    public E set(int index, E element) {
        E result = this.wrappedList.set(index, element);
        this.fireEvent(OBJECT_CHANGED_EVENT, Integer.valueOf(this.wrappedList.size()));
        return result;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.wrappedList.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.wrappedList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.wrappedList.toArray(a);
    }
}

