/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.event.collection;

import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Set;
import org.djutils.event.Event;
import org.djutils.event.EventListener;
import org.djutils.event.EventType;
import org.djutils.event.LocalEventProducer;
import org.djutils.event.collection.EventProducingIterator;
import org.djutils.event.reference.ReferenceType;
import org.djutils.exceptions.Throw;
import org.djutils.metadata.MetaData;
import org.djutils.metadata.ObjectDescriptor;

public class EventProducingSet<E>
extends LocalEventProducer
implements EventListener,
Set<E> {
    private static final long serialVersionUID = 20191230L;
    public static final EventType OBJECT_ADDED_EVENT = new EventType("OBJECT_ADDED_EVENT", new MetaData("Size of the set after add", "Size of the set", new ObjectDescriptor("Size of the set after add", "Size of the set", Integer.class)));
    public static final EventType OBJECT_REMOVED_EVENT = new EventType("OBJECT_REMOVED_EVENT", new MetaData("Size of the set after remove", "Size of the set", new ObjectDescriptor("Size of the set after remove", "Size of the set", Integer.class)));
    public static final EventType OBJECT_CHANGED_EVENT = new EventType("OBJECT_CHANGED_EVENT", new MetaData("Size of the set after change", "Size of the set", new ObjectDescriptor("Size of the set after change", "Size of the set", Integer.class)));
    private Set<E> wrappedSet = null;

    public EventProducingSet(Set<E> wrappedSet) {
        Throw.whenNull(wrappedSet, "wrappedSet cannot be null");
        this.wrappedSet = wrappedSet;
    }

    @Override
    public int size() {
        return this.wrappedSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedSet.isEmpty();
    }

    @Override
    public void clear() {
        int nr = this.wrappedSet.size();
        this.wrappedSet.clear();
        if (nr != this.wrappedSet.size()) {
            this.fireEvent(OBJECT_REMOVED_EVENT, Integer.valueOf(this.wrappedSet.size()));
        }
    }

    @Override
    public boolean add(E o) {
        boolean changed = this.wrappedSet.add(o);
        if (changed) {
            this.fireEvent(OBJECT_ADDED_EVENT, Integer.valueOf(this.wrappedSet.size()));
        } else {
            this.fireEvent(OBJECT_CHANGED_EVENT, Integer.valueOf(this.wrappedSet.size()));
        }
        return changed;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = this.wrappedSet.addAll(c);
        if (changed) {
            this.fireEvent(OBJECT_ADDED_EVENT, Integer.valueOf(this.wrappedSet.size()));
        } else if (!c.isEmpty()) {
            this.fireEvent(OBJECT_CHANGED_EVENT, Integer.valueOf(this.wrappedSet.size()));
        }
        return changed;
    }

    @Override
    public boolean contains(Object o) {
        return this.wrappedSet.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.wrappedSet.containsAll(c);
    }

    @Override
    public EventProducingIterator<E> iterator() {
        EventProducingIterator<E> iterator = new EventProducingIterator<E>(this.wrappedSet.iterator());
        iterator.addListener((EventListener)this, EventProducingIterator.OBJECT_REMOVED_EVENT, ReferenceType.WEAK);
        return iterator;
    }

    @Override
    public void notify(Event event) throws RemoteException {
        if (event.getType().equals(EventProducingIterator.OBJECT_REMOVED_EVENT)) {
            this.fireEvent(OBJECT_REMOVED_EVENT, Integer.valueOf(this.wrappedSet.size()));
        }
    }

    @Override
    public boolean remove(Object o) {
        boolean changed = this.wrappedSet.remove(o);
        if (changed) {
            this.fireEvent(OBJECT_REMOVED_EVENT, Integer.valueOf(this.wrappedSet.size()));
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = this.wrappedSet.removeAll(c);
        if (changed) {
            this.fireEvent(OBJECT_REMOVED_EVENT, Integer.valueOf(this.wrappedSet.size()));
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = this.wrappedSet.retainAll(c);
        if (changed) {
            this.fireEvent(OBJECT_REMOVED_EVENT, Integer.valueOf(this.wrappedSet.size()));
        }
        return changed;
    }

    @Override
    public Object[] toArray() {
        return this.wrappedSet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.wrappedSet.toArray(a);
    }
}

