/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.event.reference;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.djutils.event.reference.Reference;
import org.pmw.tinylog.Logger;

public class WeakReference<T extends Serializable>
extends Reference<T> {
    private static final long serialVersionUID = 20140830L;
    private final transient java.lang.ref.WeakReference<T> referent;

    public WeakReference(T referent) {
        this.referent = new java.lang.ref.WeakReference<T>(referent);
    }

    @Override
    public final T get() {
        return (T)((Serializable)this.referent.get());
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.get());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            Field field = this.getClass().getDeclaredField("referent");
            field.setAccessible(true);
            field.set(this, new java.lang.ref.WeakReference<Serializable>((Serializable)in.readObject()));
            field.setAccessible(false);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            Logger.error((Throwable)exception, (String)"Error using ReadObject on StrongReference");
        }
    }
}

