/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.exceptions;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.List;
import org.djutils.reflection.ClassUtil;

public final class Try {
    private Try() {
    }

    public static <V> V assign(Assignment<V> assignment, String message) throws RuntimeException {
        try {
            return assignment.assign();
        }
        catch (Throwable cause) {
            throw Try.catchThrowable(RuntimeException.class, message, new ArrayList<Object>(), cause);
        }
    }

    public static <V> V assign(Assignment<V> assignment, String message, Object arg) throws RuntimeException {
        try {
            return assignment.assign();
        }
        catch (Throwable cause) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg);
            throw Try.catchThrowable(RuntimeException.class, message, argList, cause);
        }
    }

    public static <V> V assign(Assignment<V> assignment, String message, Object arg1, Object arg2) throws RuntimeException {
        try {
            return assignment.assign();
        }
        catch (Throwable cause) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg1);
            argList.add(arg2);
            throw Try.catchThrowable(RuntimeException.class, message, argList, cause);
        }
    }

    public static <V> V assign(Assignment<V> assignment, String message, Object arg1, Object arg2, Object arg3) throws RuntimeException {
        try {
            return assignment.assign();
        }
        catch (Throwable cause) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg1);
            argList.add(arg2);
            argList.add(arg3);
            throw Try.catchThrowable(RuntimeException.class, message, argList, cause);
        }
    }

    public static <V> V assign(Assignment<V> assignment, String message, Object arg1, Object arg2, Object arg3, Object ... args) throws RuntimeException {
        try {
            return assignment.assign();
        }
        catch (Throwable cause) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg1);
            argList.add(arg2);
            argList.add(arg3);
            argList.addAll(Arrays.asList(args));
            throw Try.catchThrowable(RuntimeException.class, message, argList, cause);
        }
    }

    public static <V, T extends Throwable> V assign(Assignment<V> assignment, Class<T> throwableClass, String message) throws T {
        try {
            return assignment.assign();
        }
        catch (Throwable cause) {
            throw Try.catchThrowable(throwableClass, message, new ArrayList<Object>(), cause);
        }
    }

    public static <V, T extends Throwable> V assign(Assignment<V> assignment, Class<T> throwableClass, String message, Object arg) throws T {
        try {
            return assignment.assign();
        }
        catch (Throwable cause) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg);
            throw Try.catchThrowable(throwableClass, message, argList, cause);
        }
    }

    public static <V, T extends Throwable> V assign(Assignment<V> assignment, Class<T> throwableClass, String message, Object arg1, Object arg2) throws T {
        try {
            return assignment.assign();
        }
        catch (Throwable cause) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg1);
            argList.add(arg2);
            throw Try.catchThrowable(throwableClass, message, argList, cause);
        }
    }

    public static <V, T extends Throwable> V assign(Assignment<V> assignment, Class<T> throwableClass, String message, Object arg1, Object arg2, Object arg3) throws T {
        try {
            return assignment.assign();
        }
        catch (Throwable cause) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg1);
            argList.add(arg2);
            argList.add(arg3);
            throw Try.catchThrowable(throwableClass, message, argList, cause);
        }
    }

    public static <V, T extends Throwable> V assign(Assignment<V> assignment, Class<T> throwableClass, String message, Object arg1, Object arg2, Object arg3, Object ... args) throws T {
        try {
            return assignment.assign();
        }
        catch (Throwable cause) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg1);
            argList.add(arg2);
            argList.add(arg3);
            argList.addAll(Arrays.asList(args));
            throw Try.catchThrowable(throwableClass, message, argList, cause);
        }
    }

    public static void execute(Execution execution, String message) throws RuntimeException {
        try {
            execution.execute();
        }
        catch (Throwable cause) {
            throw Try.catchThrowable(RuntimeException.class, message, new ArrayList<Object>(), cause);
        }
    }

    public static void execute(Execution execution, String message, Object arg) throws RuntimeException {
        try {
            execution.execute();
        }
        catch (Throwable cause) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg);
            throw Try.catchThrowable(RuntimeException.class, message, argList, cause);
        }
    }

    public static void execute(Execution execution, String message, Object arg1, Object arg2) throws RuntimeException {
        try {
            execution.execute();
        }
        catch (Throwable cause) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg1);
            argList.add(arg2);
            throw Try.catchThrowable(RuntimeException.class, message, argList, cause);
        }
    }

    public static void execute(Execution execution, String message, Object arg1, Object arg2, Object arg3) throws RuntimeException {
        try {
            execution.execute();
        }
        catch (Throwable cause) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg1);
            argList.add(arg2);
            argList.add(arg3);
            throw Try.catchThrowable(RuntimeException.class, message, argList, cause);
        }
    }

    public static void execute(Execution execution, String message, Object arg1, Object arg2, Object arg3, Object ... args) throws RuntimeException {
        try {
            execution.execute();
        }
        catch (Throwable cause) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg1);
            argList.add(arg2);
            argList.add(arg3);
            argList.addAll(Arrays.asList(args));
            throw Try.catchThrowable(RuntimeException.class, message, argList, cause);
        }
    }

    public static <T extends Throwable> void execute(Execution execution, Class<T> throwableClass, String message) throws T {
        try {
            execution.execute();
        }
        catch (Throwable cause) {
            throw Try.catchThrowable(throwableClass, message, new ArrayList<Object>(), cause);
        }
    }

    public static <T extends Throwable> void execute(Execution execution, Class<T> throwableClass, String message, Object arg) throws T {
        try {
            execution.execute();
        }
        catch (Throwable cause) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg);
            throw Try.catchThrowable(throwableClass, message, argList, cause);
        }
    }

    public static <T extends Throwable> void execute(Execution execution, Class<T> throwableClass, String message, Object arg1, Object arg2) throws T {
        try {
            execution.execute();
        }
        catch (Throwable cause) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg1);
            argList.add(arg2);
            throw Try.catchThrowable(throwableClass, message, argList, cause);
        }
    }

    public static <T extends Throwable> void execute(Execution execution, Class<T> throwableClass, String message, Object arg1, Object arg2, Object arg3) throws T {
        try {
            execution.execute();
        }
        catch (Throwable cause) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg1);
            argList.add(arg2);
            argList.add(arg3);
            throw Try.catchThrowable(throwableClass, message, argList, cause);
        }
    }

    public static <T extends Throwable> void execute(Execution execution, Class<T> throwableClass, String message, Object arg1, Object arg2, Object arg3, Object ... args) throws T {
        try {
            execution.execute();
        }
        catch (Throwable cause) {
            ArrayList<Object> argList = new ArrayList<Object>();
            argList.add(arg1);
            argList.add(arg2);
            argList.add(arg3);
            argList.addAll(Arrays.asList(args));
            throw Try.catchThrowable(throwableClass, message, argList, cause);
        }
    }

    private static <T extends Throwable> T catchThrowable(Class<T> throwableClass, String message, List<Object> argList, Throwable cause) {
        Throwable exception;
        String formattedMessage;
        ArrayList<StackTraceElement> steList = new ArrayList<StackTraceElement>(Arrays.asList(new Throwable().getStackTrace()));
        if (steList.size() > 2) {
            steList.remove(0);
            steList.remove(0);
        }
        StackTraceElement[] ste = steList.toArray(new StackTraceElement[steList.size()]);
        String where = ste[0].getClassName() + "." + ste[0].getMethodName() + " (" + ste[0].getLineNumber() + "): ";
        Object[] args = argList.toArray();
        try {
            formattedMessage = where + String.format(message, args);
        }
        catch (IllegalFormatException exception2) {
            formattedMessage = where + message + " [FormatException; args=" + argList + "]";
        }
        try {
            Constructor<T> constructor = ClassUtil.resolveConstructor(throwableClass, new Class[]{String.class, Throwable.class});
            ArrayList<StackTraceElement> steCause = new ArrayList<StackTraceElement>(Arrays.asList(cause.getStackTrace()));
            if (steCause.size() > 3) {
                steCause.remove(steCause.size() - 1);
                steCause.remove(steCause.size() - 1);
                steCause.remove(steCause.size() - 1);
                cause.setStackTrace(steCause.toArray(new StackTraceElement[steCause.size()]));
            }
            exception = (Throwable)constructor.newInstance(formattedMessage, cause);
            exception.setStackTrace(ste);
        }
        catch (Throwable t) {
            RuntimeException rte = new RuntimeException(t.getMessage(), new Exception(formattedMessage, cause));
            rte.setStackTrace(ste);
            throw rte;
        }
        return (T)exception;
    }

    public static <V> V testFail(Assignment<V> assignment) {
        return Try.testFail(assignment, null, Throwable.class);
    }

    public static <V> V testFail(Assignment<V> assignment, String message) {
        return Try.testFail(assignment, message, Throwable.class);
    }

    public static <V, T extends Throwable> V testFail(Assignment<V> assignment, Class<T> expectedThrowableClass) {
        return Try.testFail(assignment, null, expectedThrowableClass);
    }

    public static <V, T extends Throwable> V testFail(Assignment<V> assignment, String message, Class<T> expectedThrowableClass) {
        try {
            assignment.assign();
        }
        catch (Throwable cause) {
            if (!expectedThrowableClass.isAssignableFrom(cause.getClass())) {
                throw new AssertionError((Object)(message + "; Assignment failed on unexpected Throwable, expected (" + expectedThrowableClass.getSimpleName() + "), but got (" + cause.getClass().getSimpleName() + ")."));
            }
            return null;
        }
        throw new AssertionError((Object)(message + "; Assignment did not throw any exception"));
    }

    public static void testFail(Execution execution) {
        Try.testFail(execution, null, Throwable.class);
    }

    public static void testFail(Execution execution, String message) {
        Try.testFail(execution, message, Throwable.class);
    }

    public static <T extends Throwable> void testFail(Execution execution, Class<T> expectedThrowableClass) {
        Try.testFail(execution, null, expectedThrowableClass);
    }

    public static <T extends Throwable> void testFail(Execution execution, String message, Class<T> expectedThrowableClass) {
        try {
            execution.execute();
        }
        catch (Throwable cause) {
            if (!expectedThrowableClass.isAssignableFrom(cause.getClass())) {
                throw new AssertionError((Object)(message + "; Execution failed on unexpected Throwable, expected (" + expectedThrowableClass.getSimpleName() + "), but got (" + cause.getClass().getSimpleName() + ")."));
            }
            return;
        }
        throw new AssertionError((Object)(message + "; Execution did not throw any exception"));
    }

    @FunctionalInterface
    public static interface Execution {
        public void execute() throws Throwable;
    }

    @FunctionalInterface
    public static interface Assignment<V> {
        public V assign() throws Throwable;
    }
}

