/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.immutablecollections;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.djutils.immutablecollections.Immutable;
import org.djutils.immutablecollections.ImmutableArrayList;
import org.djutils.immutablecollections.ImmutableCollection;
import org.djutils.immutablecollections.ImmutableHashMap;
import org.djutils.immutablecollections.ImmutableHashSet;
import org.djutils.immutablecollections.ImmutableList;
import org.djutils.immutablecollections.ImmutableMap;
import org.djutils.immutablecollections.ImmutableSet;

public final class ImmutableCollections {
    private ImmutableCollections() {
    }

    public static <T> ImmutableSet<T> emptyImmutableSet() {
        return new ImmutableHashSet(Collections.emptySet(), Immutable.WRAP);
    }

    public static <T, V> ImmutableMap<T, V> emptyImmutableMap() {
        return new ImmutableHashMap(Collections.emptyMap(), Immutable.WRAP);
    }

    public static <T> ImmutableList<T> emptyImmutableList() {
        return new ImmutableArrayList(Collections.emptyList(), Immutable.WRAP);
    }

    public static <T> int binarySearch(ImmutableList<? extends Comparable<? super T>> il, T key) {
        return Collections.binarySearch(il.toList(), key);
    }

    public static <T> int binarySearch(ImmutableList<? extends T> il, T key, Comparator<? super T> comparator) {
        return Collections.binarySearch(il.toList(), key, comparator);
    }

    public static boolean disjoint(ImmutableCollection<?> ic1, ImmutableCollection<?> ic2) {
        return Collections.disjoint(ic1.toCollection(), ic2.toCollection());
    }

    public static boolean disjoint(ImmutableCollection<?> ic1, Collection<?> c2) {
        return Collections.disjoint(ic1.toCollection(), c2);
    }

    public static boolean disjoint(Collection<?> c1, ImmutableCollection<?> ic2) {
        return Collections.disjoint(c1, ic2.toCollection());
    }

    public static int indexOfSubList(ImmutableList<?> source, ImmutableList<?> target) {
        return Collections.indexOfSubList(source.toList(), target.toList());
    }

    public static int indexOfSubList(ImmutableList<?> source, List<?> target) {
        return Collections.indexOfSubList(source.toList(), target);
    }

    public static int indexOfSubList(List<?> source, ImmutableList<?> target) {
        return Collections.indexOfSubList(source, target.toList());
    }

    public static int lastIndexOfSubList(ImmutableList<?> source, ImmutableList<?> target) {
        return Collections.lastIndexOfSubList(source.toList(), target.toList());
    }

    public static int lastIndexOfSubList(ImmutableList<?> source, List<?> target) {
        return Collections.lastIndexOfSubList(source.toList(), target);
    }

    public static int lastIndexOfSubList(List<?> source, ImmutableList<?> target) {
        return Collections.indexOfSubList(source, target.toList());
    }

    public static <T> T max(ImmutableCollection<? extends T> ic) {
        return Collections.max(ic.toCollection());
    }

    public static <T> T max(ImmutableCollection<? extends T> ic, Comparator<? super T> comparator) {
        return Collections.max(ic.toCollection(), comparator);
    }

    public static <T> T min(ImmutableCollection<? extends T> ic) {
        return Collections.min(ic.toCollection());
    }

    public static <T> T min(ImmutableCollection<? extends T> ic, Comparator<? super T> comparator) {
        return Collections.min(ic.toCollection(), comparator);
    }

    public static int frequency(ImmutableCollection<?> ic, Object o) {
        return Collections.frequency(ic.toCollection(), o);
    }
}

