/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.immutablecollections;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.djutils.immutablecollections.Immutable;
import org.djutils.immutablecollections.ImmutableAbstractMap;
import org.djutils.immutablecollections.ImmutableHashSet;
import org.djutils.immutablecollections.ImmutableMap;
import org.djutils.immutablecollections.ImmutableSet;

public class ImmutableHashMap<K, V>
extends ImmutableAbstractMap<K, V> {
    private static final long serialVersionUID = 20160507L;
    private ImmutableSet<K> cachedKeySet = null;
    private ImmutableSet<ImmutableMap.ImmutableEntry<K, V>> cachedEntrySet = null;

    public ImmutableHashMap(Map<K, V> map) {
        super(new HashMap<K, V>(map), Immutable.COPY);
    }

    public ImmutableHashMap(Map<K, V> map, Immutable copyOrWrap) {
        super(copyOrWrap == Immutable.COPY ? new HashMap(map) : map, copyOrWrap);
    }

    public ImmutableHashMap(ImmutableAbstractMap<K, V> immutableMap) {
        super(new HashMap<K, V>(immutableMap.getUnderlyingMap()), Immutable.COPY);
    }

    public ImmutableHashMap(ImmutableAbstractMap<K, V> immutableMap, Immutable copyOrWrap) {
        super(copyOrWrap == Immutable.COPY ? new HashMap<K, V>(immutableMap.getUnderlyingMap()) : immutableMap.getUnderlyingMap(), copyOrWrap);
    }

    @Override
    protected final Map<K, V> getUnderlyingMap() {
        return super.getUnderlyingMap();
    }

    @Override
    public final Map<K, V> toMap() {
        return new HashMap<K, V>(this.getUnderlyingMap());
    }

    @Override
    public final ImmutableSet<K> keySet() {
        if (this.cachedKeySet == null) {
            HashSet<K> immutableKeySet = new HashSet<K>(this.getUnderlyingMap().keySet());
            this.cachedKeySet = new ImmutableHashSet<K>(immutableKeySet, Immutable.WRAP);
        }
        return this.cachedKeySet;
    }

    @Override
    public ImmutableSet<ImmutableMap.ImmutableEntry<K, V>> entrySet() {
        if (this.cachedEntrySet == null) {
            HashSet<ImmutableMap.ImmutableEntry<K, V>> immutableEntrySet = new HashSet<ImmutableMap.ImmutableEntry<K, V>>();
            for (Map.Entry<K, V> entry : this.getUnderlyingMap().entrySet()) {
                immutableEntrySet.add(new ImmutableMap.ImmutableEntry<K, V>(entry));
            }
            this.cachedEntrySet = new ImmutableHashSet<ImmutableMap.ImmutableEntry<K, V>>(immutableEntrySet, Immutable.WRAP);
        }
        return this.cachedEntrySet;
    }

    @Override
    public String toString() {
        Map<K, V> map = this.getUnderlyingMap();
        if (null == map) {
            return "ImmutableHashMap []";
        }
        return "ImmutableHashMap [" + map.toString() + "]";
    }
}

