/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.immutablecollections;

import java.io.Serializable;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.djutils.immutablecollections.Immutable;
import org.djutils.immutablecollections.ImmutableCollection;
import org.djutils.immutablecollections.ImmutableLinkedHashMap;
import org.djutils.immutablecollections.ImmutableSet;

public interface ImmutableMap<K, V>
extends Serializable {
    public int size();

    public boolean isEmpty();

    public boolean containsKey(Object var1);

    public boolean containsValue(Object var1);

    public V get(Object var1);

    public ImmutableSet<K> keySet();

    public ImmutableSet<ImmutableEntry<K, V>> entrySet();

    public ImmutableCollection<V> values();

    default public V getOrDefault(Object key, V defaultValue) {
        V v = this.get(key);
        return v != null || this.containsKey(key) ? v : defaultValue;
    }

    default public void forEach(BiConsumer<? super K, ? super V> action) {
        Objects.requireNonNull(action);
        for (ImmutableEntry immutableEntry : this.entrySet()) {
            Object v;
            Object k;
            try {
                k = immutableEntry.getKey();
                v = immutableEntry.getValue();
            }
            catch (IllegalStateException ise) {
                throw new ConcurrentModificationException(ise);
            }
            action.accept(k, v);
        }
    }

    public Map<K, V> toMap();

    public boolean equals(Object var1);

    public int hashCode();

    public boolean isWrap();

    default public boolean isCopy() {
        return !this.isWrap();
    }

    public static <K, V> ImmutableMap<K, V> of() {
        return new ImmutableLinkedHashMap(new LinkedHashMap(), Immutable.WRAP);
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        return new ImmutableLinkedHashMap(map, Immutable.WRAP);
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        return new ImmutableLinkedHashMap(map, Immutable.WRAP);
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        return new ImmutableLinkedHashMap(map, Immutable.WRAP);
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        return new ImmutableLinkedHashMap(map, Immutable.WRAP);
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        return new ImmutableLinkedHashMap(map, Immutable.WRAP);
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        return new ImmutableLinkedHashMap(map, Immutable.WRAP);
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        return new ImmutableLinkedHashMap(map, Immutable.WRAP);
    }

    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        map.put(k7, v7);
        map.put(k8, v8);
        return new ImmutableLinkedHashMap(map, Immutable.WRAP);
    }

    public String toString();

    public static class ImmutableEntry<K, V> {
        private final Map.Entry<K, V> wrappedEntry;

        public ImmutableEntry(Map.Entry<K, V> wrappedEntry) {
            this.wrappedEntry = wrappedEntry;
        }

        public K getKey() {
            return this.wrappedEntry.getKey();
        }

        public V getValue() {
            return this.wrappedEntry.getValue();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.wrappedEntry == null ? 0 : this.wrappedEntry.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImmutableEntry other = (ImmutableEntry)obj;
            return !(this.wrappedEntry == null ? other.wrappedEntry != null : !this.wrappedEntry.equals(other.wrappedEntry));
        }

        public static <K extends Comparable<? super K>, V> Comparator<ImmutableEntry<K, V>> comparingByKey() {
            return (Comparator & Serializable)(c1, c2) -> ((Comparable)c1.getKey()).compareTo(c2.getKey());
        }

        public static <K, V extends Comparable<? super V>> Comparator<ImmutableEntry<K, V>> comparingByValue() {
            return (Comparator & Serializable)(c1, c2) -> ((Comparable)c1.getValue()).compareTo(c2.getValue());
        }

        public static <K, V> Comparator<ImmutableEntry<K, V>> comparingByKey(Comparator<? super K> cmp) {
            Objects.requireNonNull(cmp);
            return (Comparator & Serializable)(c1, c2) -> cmp.compare((Object)c1.getKey(), (Object)c2.getKey());
        }

        public static <K, V> Comparator<ImmutableEntry<K, V>> comparingByValue(Comparator<? super V> cmp) {
            Objects.requireNonNull(cmp);
            return (Comparator & Serializable)(c1, c2) -> cmp.compare((Object)c1.getValue(), (Object)c2.getValue());
        }

        public String toString() {
            return "ImmutableEntry [wrappedEntry=" + this.wrappedEntry + "]";
        }
    }
}

