/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.immutablecollections;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.djutils.immutablecollections.Immutable;
import org.djutils.immutablecollections.ImmutableSet;
import org.djutils.immutablecollections.ImmutableTreeSet;

public interface ImmutableSortedSet<E>
extends ImmutableSet<E> {
    @Override
    public SortedSet<E> toSet();

    public Comparator<? super E> comparator();

    public ImmutableSortedSet<E> subSet(E var1, E var2);

    public ImmutableSortedSet<E> headSet(E var1);

    public ImmutableSortedSet<E> tailSet(E var1);

    public E first();

    public E last();

    @Override
    public boolean equals(Object var1);

    @Override
    public int hashCode();

    public static <E> ImmutableSortedSet<E> of() {
        return new ImmutableTreeSet(new TreeSet(), Immutable.WRAP);
    }

    public static <E> ImmutableSortedSet<E> of(E v1) {
        TreeSet<E> set = new TreeSet<E>();
        set.add(v1);
        return new ImmutableTreeSet(set, Immutable.WRAP);
    }

    public static <E> ImmutableSortedSet<E> of(E v1, E v2) {
        TreeSet<E> set = new TreeSet<E>();
        set.add(v1);
        set.add(v2);
        return new ImmutableTreeSet(set, Immutable.WRAP);
    }

    public static <E> ImmutableSortedSet<E> of(E v1, E v2, E v3) {
        TreeSet<E> set = new TreeSet<E>();
        set.add(v1);
        set.add(v2);
        set.add(v3);
        return new ImmutableTreeSet(set, Immutable.WRAP);
    }

    public static <E> ImmutableSortedSet<E> of(E v1, E v2, E v3, E v4) {
        TreeSet<E> set = new TreeSet<E>();
        set.add(v1);
        set.add(v2);
        set.add(v3);
        set.add(v4);
        return new ImmutableTreeSet(set, Immutable.WRAP);
    }

    public static <E> ImmutableSortedSet<E> of(E v1, E v2, E v3, E v4, E v5, E ... vn) {
        TreeSet<E> set = new TreeSet<E>();
        set.add(v1);
        set.add(v2);
        set.add(v3);
        set.add(v4);
        set.add(v5);
        for (E v : vn) {
            set.add(v);
        }
        return new ImmutableTreeSet(set, Immutable.WRAP);
    }
}

