/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.logger;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import org.djutils.exceptions.Throw;
import org.djutils.immutablecollections.Immutable;
import org.djutils.immutablecollections.ImmutableLinkedHashSet;
import org.djutils.immutablecollections.ImmutableSet;
import org.djutils.logger.LogCategory;
import org.pmw.tinylog.Configurator;
import org.pmw.tinylog.Level;
import org.pmw.tinylog.LogEntryForwarder;
import org.pmw.tinylog.Logger;
import org.pmw.tinylog.writers.ConsoleWriter;
import org.pmw.tinylog.writers.Writer;

public final class CategoryLogger {
    public static final String DEFAULT_MESSAGE_FORMAT = "{class_name}.{method}:{line} {message|indent=4}";
    private static String defaultMessageFormat = "{class_name}.{method}:{line} {message|indent=4}";
    private static Level defaultLevel = Level.INFO;
    private static final Set<Writer> WRITERS = new LinkedHashSet<Writer>();
    private static final Map<Writer, Level> WRITER_LEVELS = new LinkedHashMap<Writer, Level>();
    private static final Map<Writer, String> WRITER_FORMATS = new LinkedHashMap<Writer, String>();
    private static final Set<LogCategory> LOG_CATEGORIES = new LinkedHashSet<LogCategory>(256);
    private static ImmutableSet<LogCategory> immutableLogCategories;
    public static final DelegateLogger DELEGATE_LOGGER;
    public static final DelegateLogger NO_LOGGER;

    private CategoryLogger() {
    }

    protected static void create() {
        Logger.getConfiguration().removeAllWriters().activate();
        CategoryLogger.addWriter((Writer)new ConsoleWriter());
        LOG_CATEGORIES.add(LogCategory.ALL);
        immutableLogCategories = new ImmutableLinkedHashSet<LogCategory>(LOG_CATEGORIES, Immutable.COPY);
    }

    public static void setAllLogMessageFormat(String newMessageFormat) {
        Configurator configurator = Logger.getConfiguration();
        defaultMessageFormat = newMessageFormat;
        configurator.formatPattern(defaultMessageFormat).level(Level.TRACE);
        for (Writer writer : WRITERS) {
            configurator.removeWriter(writer).activate();
            WRITER_FORMATS.put(writer, newMessageFormat);
            configurator.addWriter(writer, WRITER_LEVELS.get(writer), defaultMessageFormat);
        }
        configurator.activate();
    }

    public static void setAllLogLevel(Level newLevel) {
        Configurator configurator = Logger.getConfiguration();
        defaultLevel = newLevel;
        configurator.formatPattern(defaultMessageFormat).level(Level.TRACE);
        for (Writer writer : WRITERS) {
            configurator.removeWriter(writer).activate();
            WRITER_LEVELS.put(writer, newLevel);
            configurator.addWriter(writer, newLevel, WRITER_FORMATS.get(writer));
        }
        configurator.activate();
    }

    public static void setLogMessageFormat(Writer writer, String newMessageFormat) {
        Configurator configurator = Logger.getConfiguration();
        configurator.removeWriter(writer);
        WRITER_FORMATS.put(writer, newMessageFormat);
        configurator.addWriter(writer, WRITER_LEVELS.get(writer), newMessageFormat);
        configurator.activate();
    }

    public static void setLogLevel(Writer writer, Level newLevel) {
        Configurator configurator = Logger.getConfiguration();
        configurator.removeWriter(writer);
        WRITER_LEVELS.put(writer, newLevel);
        configurator.addWriter(writer, newLevel, WRITER_FORMATS.get(writer));
        configurator.activate();
    }

    public static boolean addWriter(Writer writer) {
        Throw.whenNull(writer, "writer may not be null");
        Configurator configurator = Logger.getConfiguration();
        boolean result = WRITERS.add(writer);
        WRITER_LEVELS.put(writer, defaultLevel);
        WRITER_FORMATS.put(writer, defaultMessageFormat);
        configurator.addWriter(writer, defaultLevel, defaultMessageFormat);
        configurator.activate();
        return result;
    }

    public static boolean removeWriter(Writer writer) {
        Throw.whenNull(writer, "writer may not be null");
        Configurator configurator = Logger.getConfiguration();
        boolean result = WRITERS.remove(writer);
        WRITER_LEVELS.remove(writer);
        WRITER_FORMATS.remove(writer);
        configurator.removeWriter(writer);
        configurator.activate();
        return result;
    }

    public static ImmutableSet<Writer> getWriters() {
        return new ImmutableLinkedHashSet<Writer>(WRITERS, Immutable.WRAP);
    }

    public static void addLogCategory(LogCategory logCategory) {
        LOG_CATEGORIES.add(logCategory);
        immutableLogCategories = new ImmutableLinkedHashSet<LogCategory>(LOG_CATEGORIES, Immutable.COPY);
    }

    public static void removeLogCategory(LogCategory logCategory) {
        LOG_CATEGORIES.remove(logCategory);
        immutableLogCategories = new ImmutableLinkedHashSet<LogCategory>(LOG_CATEGORIES, Immutable.COPY);
    }

    public static void setLogCategories(LogCategory ... newLogCategories) {
        LOG_CATEGORIES.clear();
        LOG_CATEGORIES.addAll(Arrays.asList(newLogCategories));
        immutableLogCategories = new ImmutableLinkedHashSet<LogCategory>(LOG_CATEGORIES, Immutable.COPY);
    }

    public static ImmutableSet<LogCategory> getLogCategories() {
        return immutableLogCategories;
    }

    public static DelegateLogger always() {
        return DELEGATE_LOGGER;
    }

    public static DelegateLogger filter(LogCategory logCategory) {
        if (LOG_CATEGORIES.contains(LogCategory.ALL)) {
            return DELEGATE_LOGGER;
        }
        if (LOG_CATEGORIES.contains(logCategory)) {
            return DELEGATE_LOGGER;
        }
        return NO_LOGGER;
    }

    public static DelegateLogger filter(LogCategory ... logCategories) {
        if (LOG_CATEGORIES.contains(LogCategory.ALL)) {
            return DELEGATE_LOGGER;
        }
        for (LogCategory logCategory : logCategories) {
            if (!LOG_CATEGORIES.contains(logCategory)) continue;
            return DELEGATE_LOGGER;
        }
        return NO_LOGGER;
    }

    public static DelegateLogger filter(Set<LogCategory> logCategories) {
        if (LOG_CATEGORIES.contains(LogCategory.ALL)) {
            return DELEGATE_LOGGER;
        }
        for (LogCategory logCategory : logCategories) {
            if (!LOG_CATEGORIES.contains(logCategory)) continue;
            return DELEGATE_LOGGER;
        }
        return NO_LOGGER;
    }

    public static DelegateLogger when(boolean condition) {
        if (condition) {
            return DELEGATE_LOGGER;
        }
        return NO_LOGGER;
    }

    public static DelegateLogger when(BooleanSupplier supplier) {
        if (supplier.getAsBoolean()) {
            return DELEGATE_LOGGER;
        }
        return NO_LOGGER;
    }

    static {
        DELEGATE_LOGGER = new DelegateLogger(true);
        NO_LOGGER = new DelegateLogger(false);
        CategoryLogger.create();
    }

    public static class DelegateLogger {
        private final boolean log;

        public DelegateLogger(boolean log) {
            this.log = log;
        }

        public DelegateLogger when(boolean condition) {
            if (this.log && condition) {
                return this;
            }
            return NO_LOGGER;
        }

        public DelegateLogger when(BooleanSupplier supplier) {
            if (this.log && supplier.getAsBoolean()) {
                return this;
            }
            return NO_LOGGER;
        }

        public void trace(Object object) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.TRACE, (Object)object);
            }
        }

        public void trace(String message) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.TRACE, (Object)message);
            }
        }

        public void trace(String message, Object ... arguments) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.TRACE, (String)message, (Object[])arguments);
            }
        }

        public void trace(Throwable exception) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.TRACE, (Object)exception);
            }
        }

        public void trace(Throwable exception, String message) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.TRACE, (Throwable)exception, (String)message, (Object[])new Object[0]);
            }
        }

        public void trace(Throwable exception, String message, Object ... arguments) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.TRACE, (Throwable)exception, (String)message, (Object[])arguments);
            }
        }

        public void debug(Object object) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.DEBUG, (Object)object);
            }
        }

        public void debug(String message) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.DEBUG, (Object)message);
            }
        }

        public void debug(String message, Object ... arguments) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.DEBUG, (String)message, (Object[])arguments);
            }
        }

        public void debug(Throwable exception) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.DEBUG, (Object)exception);
            }
        }

        public void debug(Throwable exception, String message) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.DEBUG, (Throwable)exception, (String)message, (Object[])new Object[0]);
            }
        }

        public void debug(Throwable exception, String message, Object ... arguments) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.DEBUG, (Throwable)exception, (String)message, (Object[])arguments);
            }
        }

        public void info(Object object) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.INFO, (Object)object);
            }
        }

        public void info(String message) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.INFO, (Object)message);
            }
        }

        public void info(String message, Object ... arguments) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.INFO, (String)message, (Object[])arguments);
            }
        }

        public void info(Throwable exception) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.INFO, (Object)exception);
            }
        }

        public void info(Throwable exception, String message) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.INFO, (Throwable)exception, (String)message, (Object[])new Object[0]);
            }
        }

        public void info(Throwable exception, String message, Object ... arguments) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.INFO, (Throwable)exception, (String)message, (Object[])arguments);
            }
        }

        public void warn(Object object) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.WARNING, (Object)object);
            }
        }

        public void warn(String message) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.WARNING, (Object)message);
            }
        }

        public void warn(String message, Object ... arguments) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.WARNING, (String)message, (Object[])arguments);
            }
        }

        public void warn(Throwable exception) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.WARNING, (Object)exception);
            }
        }

        public void warn(Throwable exception, String message) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.WARNING, (Throwable)exception, (String)message, (Object[])new Object[0]);
            }
        }

        public void warn(Throwable exception, String message, Object ... arguments) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.WARNING, (Throwable)exception, (String)message, (Object[])arguments);
            }
        }

        public void error(Object object) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.ERROR, (Object)object);
            }
        }

        public void error(String message) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.ERROR, (Object)message);
            }
        }

        public void error(String message, Object ... arguments) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.ERROR, (String)message, (Object[])arguments);
            }
        }

        public void error(Throwable exception) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.ERROR, (Object)exception);
            }
        }

        public void error(Throwable exception, String message) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.ERROR, (Throwable)exception, (String)message, (Object[])new Object[0]);
            }
        }

        public void error(Throwable exception, String message, Object ... arguments) {
            if (this.log) {
                LogEntryForwarder.forward((int)1, (Level)Level.ERROR, (Throwable)exception, (String)message, (Object[])arguments);
            }
        }
    }
}

