/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.means;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import org.djutils.exceptions.Throw;

public abstract class AbstractMean<MT, V extends Number, W extends Number> {
    private double weightedSumOfValues;
    private double sumOfWeights;
    private final Number unityWeight = 1;

    public abstract double getMean();

    final void increment(double value, double weight) {
        this.weightedSumOfValues += value;
        this.sumOfWeights += weight;
    }

    public final double getSum() {
        return this.weightedSumOfValues;
    }

    public final double getSumOfWeights() {
        return this.sumOfWeights;
    }

    public final AbstractMean<MT, V, W> add(V value, W weight) {
        return this.addImpl(value, (Number)weight);
    }

    protected abstract AbstractMean<MT, V, W> addImpl(V var1, Number var2);

    public final AbstractMean<MT, V, W> add(V value) {
        return this.addImpl(value, this.unityWeight);
    }

    public final AbstractMean<MT, V, W> add(Iterable<V> values, Iterable<W> weights) throws IllegalArgumentException {
        Iterator<V> itV = values.iterator();
        Iterator<W> itW = weights.iterator();
        while (itV.hasNext()) {
            Throw.when(!itW.hasNext(), IllegalArgumentException.class, "Unequal number of values and weights.");
            this.addImpl((Number)itV.next(), (Number)itW.next());
        }
        Throw.when(itW.hasNext(), IllegalArgumentException.class, "Unequal number of values and weights.");
        return this;
    }

    public final AbstractMean<MT, V, W> add(V[] values, W[] weights) throws IllegalArgumentException {
        Throw.when(values.length != weights.length, IllegalArgumentException.class, "Unequal number of values and weights.");
        for (int i = 0; i < values.length; ++i) {
            this.addImpl(values[i], (Number)weights[i]);
        }
        return this;
    }

    public final AbstractMean<MT, V, W> add(Map<V, W> map) {
        for (Map.Entry<V, W> entry : map.entrySet()) {
            this.addImpl((Number)entry.getKey(), (Number)entry.getValue());
        }
        return this;
    }

    public final AbstractMean<MT, V, W> add(Collection<V> collection, Function<V, W> weights) {
        for (Number v : collection) {
            this.addImpl(v, (Number)weights.apply(v));
        }
        return this;
    }

    public final <S> AbstractMean<MT, V, W> add(Collection<S> collection, Function<S, V> values, Function<S, W> weights) {
        for (S s : collection) {
            this.addImpl((Number)values.apply(s), (Number)weights.apply(s));
        }
        return this;
    }

    public final AbstractMean<MT, V, W> add(Iterable<V> values) {
        Iterator<V> itV = values.iterator();
        while (itV.hasNext()) {
            this.addImpl((Number)itV.next(), this.unityWeight);
        }
        return this;
    }

    public final AbstractMean<MT, V, W> add(V[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.addImpl(values[i], this.unityWeight);
        }
        return this;
    }
}

