/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.metadata;

import java.io.Serializable;
import java.util.Arrays;
import org.djutils.exceptions.Throw;
import org.djutils.metadata.ObjectDescriptor;

public class MetaData
implements Serializable {
    private static final long serialVersionUID = 20200417L;
    private final String name;
    private final String description;
    private final ObjectDescriptor[] objectDescriptors;
    public static final MetaData EMPTY = new MetaData("No data", "No data", new ObjectDescriptor[0]);
    public static final MetaData NO_META_DATA = new MetaData("No descriptive meta data provided", "Any payload is accepted", new ObjectDescriptor("No descriptive meta data provided", "Any payload is accepted", Object.class));

    public MetaData(String name, String description, ObjectDescriptor ... objectDescriptors) {
        Throw.whenNull(name, "name may not be null");
        Throw.when(name.length() == 0, IllegalArgumentException.class, "name cannot be the empty string");
        Throw.whenNull(description, "description may not be null");
        for (int i = 0; i < objectDescriptors.length; ++i) {
            ObjectDescriptor objectDescriptor = objectDescriptors[i];
            Throw.whenNull(objectDescriptor, "objectDescriptor %d may not be null", i);
        }
        this.name = name;
        this.description = description;
        this.objectDescriptors = objectDescriptors;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int size() {
        return this.objectDescriptors.length;
    }

    public ObjectDescriptor[] getObjectDescriptors() {
        return (ObjectDescriptor[])this.objectDescriptors.clone();
    }

    public String getFieldName(int index) {
        return this.getObjectDescriptor(index).getName();
    }

    public String getObjectDescription(int index) {
        return this.getObjectDescriptor(index).getDescription();
    }

    public Class<?> getObjectClass(int index) {
        return this.getObjectDescriptor(index).getObjectClass();
    }

    public ObjectDescriptor getObjectDescriptor(int index) {
        Throw.when(index < 0 || index >= this.objectDescriptors.length, IndexOutOfBoundsException.class, "Index < 0 or index >= number of object descriptors");
        return this.objectDescriptors[index];
    }

    public final void verifyComposition(Object[] objectArray) {
        if ((this.size() == 0 || this.size() == 1) && objectArray == null) {
            return;
        }
        if (this.equals(NO_META_DATA)) {
            return;
        }
        Throw.whenNull(objectArray, "objectArray may not be null");
        Throw.when(objectArray.length != this.size(), IndexOutOfBoundsException.class, "objectArray for \"%s\" has wrong length (expected %d, got %d)", (Object)this.name, (Object)this.size(), (Object)objectArray.length);
        for (int index = 0; index < objectArray.length; ++index) {
            Object object = objectArray[index];
            if (null == object || this.getObjectClass(index).isAssignableFrom(object.getClass())) continue;
            throw new ClassCastException(String.format("objectArray[%d] (%s) cannot be used for %s", index, objectArray[index], this.getObjectClass(index).getName()));
        }
    }

    public final void verifyComposition(Object object) {
        Throw.when(this.objectDescriptors.length != 1, IndexOutOfBoundsException.class, "Testing single object, but length of the object descriptors array is %d", this.objectDescriptors.length);
        if (this.equals(NO_META_DATA)) {
            return;
        }
        Class<?> objectClass = this.getObjectClass(0);
        if (!objectClass.isAssignableFrom(object.getClass())) {
            throw new ClassCastException(String.format("object (%s) cannot be used for %s", object, objectClass.getName()));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Arrays.hashCode(this.objectDescriptors);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaData other = (MetaData)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!this.description.equals(other.description)) {
            return false;
        }
        return Arrays.equals(this.objectDescriptors, other.objectDescriptors);
    }

    public String toString() {
        return "MetaData [name=" + this.name + ", description=" + this.description + ", objectDescriptors=" + Arrays.toString(this.objectDescriptors) + "]";
    }
}

