/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.metadata;

import java.io.Serializable;
import org.djutils.exceptions.Throw;

public class ObjectDescriptor
implements Serializable {
    private static final long serialVersionUID = 20200417L;
    private final String name;
    private final String description;
    private final Class<?> objectClass;

    public ObjectDescriptor(String name, String description, Class<?> objectClass) {
        Throw.whenNull(name, "name may not be null");
        Throw.when(name.length() == 0, IllegalArgumentException.class, "empty name is not allowed");
        Throw.whenNull(description, "description may not be null");
        Throw.whenNull(objectClass, "objectClass may not be null");
        this.name = name;
        this.description = description;
        this.objectClass = objectClass;
    }

    String getName() {
        return this.name;
    }

    String getDescription() {
        return this.description;
    }

    public Class<?> getObjectClass() {
        return this.objectClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.description.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.objectClass.getName().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectDescriptor other = (ObjectDescriptor)obj;
        if (!this.description.equals(other.description)) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        return this.objectClass.equals(other.objectClass);
    }

    public String toString() {
        return "ObjectDescriptor [name=" + this.name + ", description=" + this.description + ", objectClass=" + this.objectClass + "]";
    }
}

