/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.polynomialroots;

import org.djutils.complex.Complex;

public final class PolynomialRoots {
    private PolynomialRoots() {
    }

    private static double sign(double a, double b) {
        return b >= 0.0 ? a : -a;
    }

    public static Complex[] linearRoots(double q1, double q0) {
        if (q1 == 0.0) {
            return new Complex[0];
        }
        return PolynomialRoots.linearRoots(q0 / q1);
    }

    public static Complex[] linearRoots(double q0) {
        return new Complex[]{new Complex(-q0, 0.0)};
    }

    public static Complex[] quadraticRoots(double q2, double q1, double q0) {
        if (q2 == 0.0) {
            return PolynomialRoots.linearRoots(q1, q0);
        }
        return PolynomialRoots.quadraticRoots(q1 / q2, q0 / q2);
    }

    public static Complex[] quadraticRoots(double q1, double q0) {
        double a0;
        double a1;
        double z;
        double y;
        double x;
        boolean rescale;
        double k = 0.0;
        if (q0 == 0.0 && q1 == 0.0) {
            return new Complex[]{Complex.ZERO, Complex.ZERO};
        }
        if (q0 == 0.0) {
            Complex nonZeroRoot = new Complex(-q1);
            return new Complex[]{q1 > 0.0 ? Complex.ZERO : nonZeroRoot, q1 <= 0.0 ? nonZeroRoot : Complex.ZERO};
        }
        if (q1 == 0.0) {
            double x2 = Math.sqrt(Math.abs(q0));
            if (q0 < 0.0) {
                return new Complex[]{new Complex(x2, 0.0), new Complex(-x2, 0.0)};
            }
            return new Complex[]{new Complex(0.0, x2), new Complex(0.0, -x2)};
        }
        double sqrtLPN = Math.sqrt(Double.MAX_VALUE);
        boolean bl = rescale = q1 > sqrtLPN + sqrtLPN;
        if (!rescale) {
            x = q1 * 0.5;
            boolean bl2 = rescale = q0 < x * x - Double.MAX_VALUE;
        }
        if (rescale) {
            x = Math.abs(q1);
            if (x > (y = Math.sqrt(Math.abs(q0)))) {
                k = x;
                z = 1.0 / x;
                a1 = PolynomialRoots.sign(1.0, q1);
                a0 = q0 * z * z;
            } else {
                k = y;
                a1 = q1 / y;
                a0 = PolynomialRoots.sign(1.0, q0);
            }
        } else {
            a1 = q1;
            a0 = q0;
        }
        x = a1 * 0.5;
        y = x * x - a0;
        if (y >= 0.0) {
            y = Math.sqrt(y);
            y = x > 0.0 ? -x - y : -x + y;
            z = rescale ? q0 / (y *= k) : a0 / y;
            return new Complex[]{new Complex(Math.max(y, z), 0.0), new Complex(Math.min(y, z), 0.0)};
        }
        y = Math.sqrt(-y);
        if (rescale) {
            x *= k;
            y *= k;
        }
        return new Complex[]{new Complex(-x, y), new Complex(-x, -y)};
    }

    public static Complex[] cubicRoots(double c3, double c2, double c1, double c0) {
        if (c3 == 0.0) {
            return PolynomialRoots.quadraticRoots(c2, c1, c0);
        }
        return PolynomialRoots.cubicRoots(c2 / c3, c1 / c3, c0 / c3, false);
    }

    public static Complex[] cubicRoots(double c2, double c1, double c0) {
        return PolynomialRoots.cubicRoots(c2, c1, c0, false);
    }

    public static Complex[] cubicRoots(double c2, double c1, double c0, boolean verbose) {
        double z;
        double y;
        int cubicType;
        double macheps = Math.ulp(1.0);
        double one27th = 0.037037037037037035;
        double two27th = 0.07407407407407407;
        double third = 0.3333333333333333;
        double p51 = 0.878558;
        double p52 = 0.192823;
        double p53 = 1.19748;
        double p54 = 0.345219;
        double q51 = 0.571888;
        double q52 = 0.566324;
        double q53 = 0.283772;
        double q54 = 0.401231;
        double r51 = 0.711154;
        double r52 = 0.505734;
        double r53 = 0.837476;
        double r54 = 0.207216;
        double s51 = 0.322313;
        double s52 = 0.264881;
        double s53 = 0.356228;
        double s54 = 0.00445532;
        boolean allzero = false;
        boolean linear = true;
        int quadratic = 2;
        int general = 3;
        double a0 = 0.0;
        double a1 = 0.0;
        double a2 = 0.0;
        double a = 0.0;
        double b = 0.0;
        double c = 0.0;
        double k = 0.0;
        double s = 0.0;
        double u = 0.0;
        double x = 0.0;
        double xShift = 0.0;
        if (verbose) {
            System.out.println("initial cubic c2      = " + c2);
            System.out.println("initial cubic c1      = " + c1);
            System.out.println("initial cubic c0      = " + c0);
            System.out.println("------------------------------------------------");
        }
        if (c0 == 0.0 && c1 == 0.0 && c2 == 0.0) {
            cubicType = 0;
        } else if (c0 == 0.0 && c1 == 0.0) {
            k = 1.0;
            a2 = c2;
            cubicType = 1;
        } else if (c0 == 0.0) {
            k = 1.0;
            a2 = c2;
            a1 = c1;
            cubicType = 2;
        } else {
            x = Math.abs(c2);
            y = Math.sqrt(Math.abs(c1));
            z = Math.cbrt(Math.abs(c0));
            u = Math.max(Math.max(x, y), z);
            if (u == x) {
                k = 1.0 / x;
                a2 = PolynomialRoots.sign(1.0, c2);
                a1 = c1 * k * k;
                a0 = c0 * k * k * k;
            } else if (u == y) {
                k = 1.0 / y;
                a2 = c2 * k;
                a1 = PolynomialRoots.sign(1.0, c1);
                a0 = c0 * k * k * k;
            } else {
                k = 1.0 / z;
                a2 = c2 * k;
                a1 = c1 * k * k;
                a0 = PolynomialRoots.sign(1.0, c0);
            }
            if (verbose) {
                System.out.println("rescaling factor      = " + k);
                System.out.println("------------------------------------------------");
                System.out.println("rescaled cubic c2     = " + a2);
                System.out.println("rescaled cubic c1     = " + a1);
                System.out.println("rescaled cubic c0     = " + a0);
                System.out.println("------------------------------------------------");
            }
            k = 1.0 / k;
            cubicType = a0 == 0.0 && a1 == 0.0 && a2 == 0.0 ? 0 : (a0 == 0.0 && a1 == 0.0 ? 1 : (a0 == 0.0 ? 2 : 3));
        }
        switch (cubicType) {
            case 0: {
                return new Complex[]{Complex.ZERO, Complex.ZERO, Complex.ZERO};
            }
            case 1: {
                double root = -a2 * k;
                return new Complex[]{new Complex(Math.max(0.0, root), 0.0), Complex.ZERO, new Complex(Math.min(0.0, root), 0.0)};
            }
            case 2: {
                Complex[] otherRoots = PolynomialRoots.quadraticRoots(a2, a1);
                if (otherRoots[0].isReal()) {
                    double xx = otherRoots[0].re * k;
                    double yy = otherRoots[1].re * k;
                    return new Complex[]{new Complex(Math.max(xx, 0.0), 0.0), new Complex(Math.max(yy, Math.min(xx, 0.0)), 0.0), new Complex(Math.min(yy, 0.0), 0.0)};
                }
                return new Complex[]{Complex.ZERO, otherRoots[0].times(k), otherRoots[1].times(k)};
            }
            case 3: {
                Complex[] quadraticRoots;
                double p1 = 1.09574;
                double q1 = 0.3239;
                double r1 = 0.3239;
                double s1 = 0.0957439;
                if (a0 == 1.0) {
                    x = -1.09574 + 0.3239 * a1 - a2 * (0.3239 - 0.0957439 * a1);
                    a = a2;
                    b = a1;
                    c = a0;
                    xShift = 0.0;
                } else if (a0 == -1.0) {
                    x = 1.09574 - 0.3239 * a1 - a2 * (0.3239 - 0.0957439 * a1);
                    a = a2;
                    b = a1;
                    c = a0;
                    xShift = 0.0;
                } else if (a1 == 1.0) {
                    double q4 = 0.771845;
                    double s4 = 0.228155;
                    x = a0 > 0.0 ? a0 * (-0.771845 - 0.228155 * a2) : a0 * (-0.771845 + 0.228155 * a2);
                    a = a2;
                    b = a1;
                    c = a0;
                    xShift = 0.0;
                } else if (a1 == -1.0) {
                    double p3 = 1.14413;
                    double q3 = 0.275509;
                    double r3 = 0.445578;
                    double s3 = 0.0259342;
                    y = -0.07407407407407407;
                    y *= a2;
                    y = y * a2 - 0.3333333333333333;
                    x = a0 < (y *= a2) ? 1.14413 - 0.275509 * a0 - a2 * (0.445578 + 0.0259342 * a0) : -1.14413 - 0.275509 * a0 - a2 * (0.445578 - 0.0259342 * a0);
                    a = a2;
                    b = a1;
                    c = a0;
                    xShift = 0.0;
                } else if (a2 == 1.0) {
                    b = a1 - 0.3333333333333333;
                    c = a0 - 0.037037037037037035;
                    if (Math.abs(b) < macheps && Math.abs(c) < macheps) {
                        x = -0.3333333333333333 * k;
                        Complex root = new Complex(x, 0.0);
                        return new Complex[]{root, root, root};
                    }
                    y = 0.3333333333333333 * a1 - 0.07407407407407407;
                    x = a1 <= 0.3333333333333333 ? (a0 > y ? -0.878558 - 0.571888 * a0 + a1 * (0.711154 - 0.322313 * a0) : 0.192823 - 0.566324 * a0 - a1 * (0.505734 + 0.264881 * a0)) : (a0 > y ? -1.19748 - 0.283772 * a0 + a1 * (0.837476 - 0.356228 * a0) : 0.345219 - 0.401231 * a0 - a1 * (0.207216 + 0.00445532 * a0));
                    if (Math.abs(b) < 0.01 && Math.abs(c) < 0.01) {
                        if (Math.abs(c = -0.3333333333333333 * b + c) < macheps) {
                            c = 0.0;
                        }
                        a = 0.0;
                        xShift = 0.3333333333333333;
                        x += xShift;
                    } else {
                        a = a2;
                        b = a1;
                        c = a0;
                        xShift = 0.0;
                    }
                } else if (a2 == -1.0) {
                    b = a1 - 0.3333333333333333;
                    c = a0 + 0.037037037037037035;
                    if (Math.abs(b) < macheps && Math.abs(c) < macheps) {
                        x = 0.3333333333333333 * k;
                        Complex root = new Complex(x, 0.0);
                        return new Complex[]{root, root, root};
                    }
                    y = 0.07407407407407407 - 0.3333333333333333 * a1;
                    x = a1 <= 0.3333333333333333 ? (a0 < y ? 0.878558 - 0.571888 * a0 - a1 * (0.711154 + 0.322313 * a0) : -0.192823 - 0.566324 * a0 + a1 * (0.505734 - 0.264881 * a0)) : (a0 < y ? 1.19748 - 0.283772 * a0 - a1 * (0.837476 + 0.356228 * a0) : -0.345219 - 0.401231 * a0 + a1 * (0.207216 - 0.00445532 * a0));
                    if (Math.abs(b) < 0.01 && Math.abs(c) < 0.01) {
                        if (Math.abs(c = 0.3333333333333333 * b + c) < macheps) {
                            c = 0.0;
                        }
                        a = 0.0;
                        xShift = -0.3333333333333333;
                        x += xShift;
                    } else {
                        a = a2;
                        b = a1;
                        c = a0;
                        xShift = 0.0;
                    }
                }
                z = x + a;
                y = x + z;
                z = z * x + b;
                y = y * x + z;
                double t = z = z * x + c;
                x -= z / y;
                int oscillate = 0;
                boolean bisection = false;
                boolean converged = false;
                while (!converged && !bisection) {
                    z = x + a;
                    y = x + z;
                    z = z * x + b;
                    y = y * x + z;
                    if ((z = z * x + c) * t < 0.0) {
                        if (z < 0.0) {
                            ++oscillate;
                            s = x;
                        } else {
                            u = x;
                        }
                        t = z;
                    }
                    y = z / y;
                    bisection = oscillate > 2;
                    boolean bl = converged = Math.abs(y) <= Math.abs(x -= y) * macheps;
                    if (!verbose) continue;
                    System.out.println("Newton root           = " + x);
                }
                if (bisection) {
                    t = u - s;
                    while (Math.abs(t) > Math.abs(x) * macheps) {
                        z = x + a;
                        z = z * x + b;
                        if ((z = z * x + c) < 0.0) {
                            s = x;
                        } else {
                            u = x;
                        }
                        t = 0.5 * (u - s);
                        x = s + t;
                        if (!verbose) continue;
                        System.out.println("Bisection root        = " + x);
                    }
                }
                if (verbose) {
                    System.out.println("------------------------------------------------");
                }
                z = Math.abs(x -= xShift);
                s = Math.abs(a2);
                t = Math.abs(a1);
                u = Math.abs(a0);
                y = z * Math.max(s, z);
                int deflateCase = 1;
                if (y < t) {
                    y = t * z;
                    deflateCase = 2;
                } else {
                    y *= z;
                }
                if (y < u) {
                    deflateCase = 3;
                }
                y = x * k;
                switch (deflateCase) {
                    case 1: {
                        x = 1.0 / y;
                        t = -c0 * x;
                        s = (t - c1) * x;
                        break;
                    }
                    case 2: {
                        s = c2 + y;
                        t = -c0 / y;
                        break;
                    }
                    case 3: {
                        s = c2 + y;
                        t = c1 + s * y;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Bad switch; cannot happen");
                    }
                }
                if (verbose) {
                    System.out.println("Residual quadratic q1 = " + s);
                    System.out.println("Residual quadratic q0 = " + t);
                    System.out.println("------------------------------------------------");
                }
                if ((quadraticRoots = PolynomialRoots.quadraticRoots(s, t))[0].isReal()) {
                    return new Complex[]{new Complex(Math.max(quadraticRoots[0].re, y), 0.0), new Complex(Math.max(quadraticRoots[1].re, Math.min(quadraticRoots[0].re, y)), 0.0), new Complex(Math.min(quadraticRoots[1].re, y), 0.0)};
                }
                return new Complex[]{new Complex(y, 0.0), quadraticRoots[0], quadraticRoots[1]};
            }
        }
        throw new RuntimeException("Bad switch; cannot happen");
    }

    public static Complex[] quarticRoots(double q4, double q3, double q2, double q1, double q0) {
        if (q4 == 0.0) {
            return PolynomialRoots.cubicRoots(q3, q2, q1, q0);
        }
        return PolynomialRoots.quarticRoots(q3 / q4, q2 / q4, q1 / q4, q0 / q4);
    }

    public static Complex[] quarticRoots(double q3, double q2, double q1, double q0) {
        return PolynomialRoots.quarticRoots(q3, q2, q1, q0, false);
    }

    public static Complex[] quarticRoots(double q3, double q2, double q1, double q0, boolean verbose) {
        double y;
        double x;
        double t;
        double s;
        int quarticType;
        double a2;
        double k;
        int biquadratic = 2;
        int cubic = 3;
        int general = 4;
        double a0 = 0.0;
        double a1 = 0.0;
        double a3 = 0.0;
        double u = 0.0;
        double macheps = Math.ulp(1.0);
        if (verbose) {
            System.out.println("initial quartic q3    = " + q3);
            System.out.println("initial quartic q2    = " + q2);
            System.out.println("initial quartic q1    = " + q1);
            System.out.println("initial quartic q0    = " + q0);
            System.out.println("------------------------------------------------");
        }
        if (q0 == 0.0) {
            k = 1.0;
            a3 = q3;
            a2 = q2;
            a1 = q1;
            quarticType = 3;
        } else if (q3 == 0.0 && q1 == 0.0) {
            k = 1.0;
            a2 = q2;
            a0 = q0;
            quarticType = 2;
        } else {
            s = Math.abs(q3);
            t = Math.sqrt(Math.abs(q2));
            u = Math.cbrt(Math.abs(q1));
            x = Math.sqrt(Math.sqrt(Math.abs(q0)));
            y = Math.max(Math.max(Math.max(s, t), u), x);
            if (y == s) {
                k = 1.0 / s;
                a3 = PolynomialRoots.sign(1.0, q3);
                a2 = q2 * k * k;
                a1 = q1 * k * k * k;
                a0 = q0 * k * k * k * k;
            } else if (y == t) {
                k = 1.0 / t;
                a3 = q3 * k;
                a2 = PolynomialRoots.sign(1.0, q2);
                a1 = q1 * k * k * k;
                a0 = q0 * k * k * k * k;
            } else if (y == u) {
                k = 1.0 / u;
                a3 = q3 * k;
                a2 = q2 * k * k;
                a1 = PolynomialRoots.sign(1.0, q1);
                a0 = q0 * k * k * k * k;
            } else {
                k = 1.0 / x;
                a3 = q3 * k;
                a2 = q2 * k * k;
                a1 = q1 * k * k * k;
                a0 = PolynomialRoots.sign(1.0, q0);
            }
            k = 1.0 / k;
            if (verbose) {
                System.out.println("rescaling factor      = " + k);
                System.out.println("------------------------------------------------");
                System.out.println("rescaled quartic q3   = " + a3);
                System.out.println("rescaled quartic q2   = " + a2);
                System.out.println("rescaled quartic q1   = " + a1);
                System.out.println("rescaled quartic q0   = " + a0);
                System.out.println("------------------------------------------------");
            }
            quarticType = a0 == 0.0 ? 3 : (a3 == 0.0 && a1 == 0.0 ? 2 : 4);
        }
        switch (quarticType) {
            case 3: {
                Complex[] cubicRoots = PolynomialRoots.cubicRoots(a3, a2, a1, verbose);
                if (cubicRoots.length == 3 && cubicRoots[0].isReal() && cubicRoots[1].isReal()) {
                    x = cubicRoots[0].re * k;
                    y = cubicRoots[1].re * k;
                    double z = cubicRoots[2].re * k;
                    return new Complex[]{new Complex(Math.max(x, 0.0), 0.0), new Complex(Math.max(y, Math.min(x, 0.0)), 0.0), new Complex(Math.max(z, Math.min(y, 0.0)), 0.0), new Complex(Math.min(z, 0.0), 0.0)};
                }
                if (!cubicRoots[0].isReal()) {
                    throw new RuntimeException("Cannot happen");
                }
                x = cubicRoots[0].re * k;
                return new Complex[]{new Complex(Math.max(0.0, x), 0.0), new Complex(Math.min(0.0, x), 0.0), cubicRoots[1], cubicRoots[2]};
            }
            case 2: {
                Complex[] quadraticRoots = PolynomialRoots.quadraticRoots(q2, q0);
                if (quadraticRoots.length == 2 && quadraticRoots[0].isReal() && quadraticRoots[1].isReal()) {
                    x = quadraticRoots[0].re;
                    y = quadraticRoots[1].re;
                    if (y >= 0.0) {
                        x = Math.sqrt(x) * k;
                        y = Math.sqrt(y) * k;
                        return new Complex[]{new Complex(x, 0.0), new Complex(y, 0.0), new Complex(-y, 0.0), new Complex(-x, 0.0)};
                    }
                    if (x >= 0.0 && y < 0.0) {
                        x = Math.sqrt(x) * k;
                        y = Math.sqrt(Math.abs(y)) * k;
                        return new Complex[]{new Complex(x, 0.0), new Complex(-x, 0.0), new Complex(0.0, y), new Complex(0.0, -y)};
                    }
                    if (x < 0.0) {
                        x = Math.sqrt(Math.abs(x)) * k;
                        y = Math.sqrt(Math.abs(y)) * k;
                        return new Complex[]{new Complex(0.0, y), new Complex(0.0, x), new Complex(0.0, -x), new Complex(0.0, -y)};
                    }
                } else {
                    x = quadraticRoots[0].re * 0.5;
                    y = quadraticRoots[0].im * 0.5;
                    double z = Math.sqrt(x * x + y * y);
                    y = Math.sqrt(z - x) * k;
                    x = Math.sqrt(z + x) * k;
                    return new Complex[]{new Complex(x, y), new Complex(x, -y), new Complex(-x, y), new Complex(-x, -y)};
                }
            }
            case 4: {
                double d;
                double c;
                double b;
                double a;
                boolean iterate;
                boolean notZero;
                int nReal;
                x = 0.75 * a3;
                y = 0.5 * a2;
                double z = 0.25 * a1;
                if (verbose) {
                    System.out.println("dQ(x)/dx cubic c2     = " + x);
                    System.out.println("dQ(x)/dx cubic c1     = " + y);
                    System.out.println("dQ(x)/dx cubic c0     = " + z);
                    System.out.println("------------------------------------------------");
                }
                Complex[] cubicRoots = PolynomialRoots.cubicRoots(x, y, z);
                s = cubicRoots[0].re;
                x = s + a3;
                x = x * s + a2;
                x = x * s + a1;
                x = x * s + a0;
                y = 1.0;
                if (cubicRoots[1].isReal()) {
                    u = cubicRoots[2].re;
                    y = u + a3;
                    y = y * u + a2;
                    y = y * u + a1;
                    y = y * u + a0;
                }
                if (verbose) {
                    System.out.println("dQ(x)/dx root s       = " + s);
                    System.out.println("Q(s)                  = " + x);
                    System.out.println("dQ(x)/dx root u       = " + u);
                    System.out.println("Q(u)                  = " + y);
                    System.out.println("------------------------------------------------");
                }
                if (x < 0.0 && y < 0.0) {
                    x = x < y ? (s < 0.0 ? 1.0 - PolynomialRoots.sign(1.0, a0) : 2.0) : (u > 0.0 ? -1.0 + PolynomialRoots.sign(1.0, a0) : -2.0);
                    nReal = 1;
                } else if (x < 0.0) {
                    x = s < -a3 * 0.25 ? (s > 0.0 ? -1.0 + PolynomialRoots.sign(1.0, a0) : -2.0) : (s < 0.0 ? 1.0 - PolynomialRoots.sign(1.0, a0) : 2.0);
                    nReal = 1;
                } else if (y < 0.0) {
                    x = u < -a3 * 0.25 ? (u > 0.0 ? -1.0 + PolynomialRoots.sign(1.0, a0) : -2.0) : (u < 0.0 ? 1.0 - PolynomialRoots.sign(1.0, a0) : 2.0);
                    nReal = 1;
                } else {
                    nReal = 0;
                }
                if (nReal > 0) {
                    int oscillate = 0;
                    boolean bisection = false;
                    boolean converged = false;
                    while (!converged && !bisection) {
                        y = x + a3;
                        z = x + y;
                        y = y * x + a2;
                        z = z * x + y;
                        y = y * x + a1;
                        z = z * x + y;
                        if ((y = y * x + a0) < 0.0) {
                            ++oscillate;
                            s = x;
                        } else {
                            u = x;
                        }
                        bisection = oscillate > 2;
                        boolean bl = converged = Math.abs(y) <= Math.abs(x -= (y /= z)) * macheps;
                        if (!verbose) continue;
                        System.out.println("Newton root           = " + x);
                    }
                    if (bisection) {
                        t = u - s;
                        while (Math.abs(t) > Math.abs(x) * macheps) {
                            y = x + a3;
                            y = y * x + a2;
                            y = y * x + a1;
                            if ((y = y * x + a0) < 0.0) {
                                s = x;
                            } else {
                                u = x;
                            }
                            t = 0.5 * (u - s);
                            x = s + t;
                            if (!verbose) continue;
                            System.out.println("Bisection root        = " + x);
                        }
                    }
                    if (verbose) {
                        System.out.println("------------------------------------------------");
                    }
                    z = Math.abs(x);
                    double a4 = Math.abs(a3);
                    double b2 = Math.abs(a2);
                    double c2 = Math.abs(a1);
                    double d2 = Math.abs(a0);
                    y = z * Math.max(a4, z);
                    int deflateCase = 1;
                    if (y < b2) {
                        y = b2 * z;
                        deflateCase = 2;
                    } else {
                        y *= z;
                    }
                    if (y < c2) {
                        y = c2 * z;
                        deflateCase = 3;
                    } else {
                        y *= z;
                    }
                    if (y < d2) {
                        deflateCase = 4;
                    }
                    x *= k;
                    switch (deflateCase) {
                        case 1: {
                            z = 1.0 / x;
                            u = -q0 * z;
                            t = (u - q1) * z;
                            s = (t - q2) * z;
                            break;
                        }
                        case 2: {
                            z = 1.0 / x;
                            u = -q0 * z;
                            t = (u - q1) * z;
                            s = q3 + x;
                            break;
                        }
                        case 3: {
                            s = q3 + x;
                            t = q2 + s * x;
                            u = -q0 / x;
                            break;
                        }
                        case 4: {
                            s = q3 + x;
                            t = q2 + s * x;
                            u = q1 + t * x;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Bad switch; cannot happen");
                        }
                    }
                    if (verbose) {
                        System.out.println("Residual cubic c2     = " + s);
                        System.out.println("Residual cubic c1     = " + t);
                        System.out.println("Residual cubic c0     = " + u);
                        System.out.println("------------------------------------------------");
                    }
                    cubicRoots = PolynomialRoots.cubicRoots(s, t, u, verbose);
                    nReal = 0;
                    for (Complex complex : cubicRoots) {
                        if (!complex.isReal()) continue;
                        ++nReal;
                    }
                    if (nReal == 3) {
                        s = cubicRoots[0].re;
                        t = cubicRoots[1].re;
                        u = cubicRoots[2].re;
                        return new Complex[]{new Complex(Math.max(s, x), 0.0), new Complex(Math.max(t, Math.min(s, x)), 0.0), new Complex(Math.max(u, Math.min(t, x)), 0.0), new Complex(Math.min(u, x), 0.0)};
                    }
                    s = cubicRoots[0].re;
                    return new Complex[]{new Complex(Math.max(s, x), 0.0), new Complex(Math.min(s, x), 0.0), cubicRoots[1], cubicRoots[2]};
                }
                s = a3 * 0.5;
                t = s * s - a2;
                u = s * t + a1;
                boolean bl = notZero = Math.abs(u) >= macheps;
                if (verbose) {
                    System.out.println("dQ/dx (-a3/4) value   = " + u);
                    System.out.println("------------------------------------------------");
                }
                boolean minimum = a3 != 0.0 ? a0 > (s = a1 / a3) * s : 4.0 * a0 > a2 * a2;
                boolean bl2 = iterate = notZero || !notZero && minimum;
                if (iterate) {
                    x = PolynomialRoots.sign(2.0, a3);
                    int oscillate = 0;
                    boolean bisection = false;
                    boolean converged = false;
                    while (!converged && !bisection) {
                        a = x + a3;
                        b = x + a;
                        c = x + b;
                        d = x + c;
                        a = a * x + a2;
                        b = b * x + a;
                        c = c * x + b;
                        a = a * x + a1;
                        b = b * x + a;
                        a = a * x + a0;
                        y = a * d * d - b * c * d + b * b;
                        z = 2.0 * d * (4.0 * a - b * d - c * c);
                        if (y > 0.0) {
                            ++oscillate;
                            s = x;
                        } else {
                            u = x;
                        }
                        bisection = oscillate > 2;
                        boolean bl3 = converged = Math.abs(y) <= Math.abs(x -= (y /= z)) * macheps;
                        if (!verbose) continue;
                        System.out.println("Newton H(x) root      = " + x);
                    }
                    if (bisection) {
                        t = u - s;
                        while (Math.abs(t) > Math.abs(x * macheps)) {
                            a = x + a3;
                            b = x + a;
                            c = x + b;
                            d = x + c;
                            a = a * x + a2;
                            b = b * x + a;
                            c = c * x + b;
                            a = a * x + a1;
                            y = (a = a * x + a0) * d * d - (b = b * x + a) * c * d + b * b;
                            if (y > 0.0) {
                                s = x;
                            } else {
                                u = x;
                            }
                            t = 0.5 * (u - s);
                            x = s + t;
                            if (!verbose) continue;
                            System.out.println("Bisection H(x) root   = " + x);
                        }
                    }
                    if (verbose) {
                        System.out.println("------------------------------------------------");
                    }
                    a = x * k;
                    b = -0.5 * q3 - a;
                    x = 4.0 * a + q3;
                    y = x + q3 + q3;
                    y = y * a + q2 + q2;
                    y = y * a + q1;
                    y = Math.max(y / x, 0.0);
                    x = 4.0 * b + q3;
                    z = x + q3 + q3;
                    z = z * b + q2 + q2;
                    z = z * b + q1;
                    c = a * a;
                    s = c + y;
                    d = b * b;
                    t = d + (z = Math.max(z / x, 0.0));
                    if (s > t) {
                        c = Math.sqrt(y);
                        d = Math.sqrt(q0 / s - d);
                    } else {
                        c = Math.sqrt(q0 / t - c);
                        d = Math.sqrt(z);
                    }
                } else {
                    b = a = -0.25 * q3;
                    x = a + q3;
                    x = x * a + q2;
                    x = x * a + q1;
                    x = x * a + q0;
                    y = -0.1875 * q3 * q3 + 0.5 * q2;
                    z = Math.max(y * y - x, 0.0);
                    z = Math.sqrt(z);
                    y += PolynomialRoots.sign(z, y);
                    c = Math.max(y, 0.0);
                    d = Math.max(x /= y, 0.0);
                    c = Math.sqrt(c);
                    d = Math.sqrt(d);
                }
                if (a > b) {
                    return new Complex[]{new Complex(a, c), new Complex(a, -c), new Complex(b, d), new Complex(b, -d)};
                }
                if (a < b) {
                    return new Complex[]{new Complex(b, d), new Complex(b, -d), new Complex(a, c), new Complex(a, -c)};
                }
                return new Complex[]{new Complex(a, c), new Complex(a, -c), new Complex(a, d), new Complex(a, -d)};
            }
        }
        throw new RuntimeException("Bad switch; cannot happen");
    }
}

