/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.polynomialroots;

import org.djutils.complex.Complex;
import org.djutils.complex.ComplexMath;
import org.djutils.polynomialroots.PolynomialRoots;

public final class PolynomialRoots2 {
    private static final int MAX_STEPS_DURAND_KERNER = 100;
    private static final int MAX_STEPS_ABERTH_EHRLICH = 100;
    private static final int MAX_STEPS_NEWTON = 100;
    private static final int MAX_STEPS_BISECTION = 100;

    private PolynomialRoots2() {
    }

    private static double sign(double a, double b) {
        return b >= 0.0 ? a : -a;
    }

    public static Complex[] linearRoots(double q1, double q0) {
        if (q1 == 0.0) {
            return new Complex[0];
        }
        return PolynomialRoots2.linearRoots(q0 / q1);
    }

    public static Complex[] linearRoots(double q0) {
        return new Complex[]{new Complex(-q0, 0.0)};
    }

    public static Complex[] quadraticRoots(double q2, double q1, double q0) {
        if (q2 == 0.0) {
            return PolynomialRoots2.linearRoots(q1, q0);
        }
        return PolynomialRoots2.quadraticRoots(q1 / q2, q0 / q2);
    }

    public static Complex[] quadraticRoots(double q1, double q0) {
        double a0;
        double a1;
        double z;
        double y;
        double x;
        boolean rescale;
        double k = 0.0;
        if (q0 == 0.0 && q1 == 0.0) {
            return new Complex[]{Complex.ZERO, Complex.ZERO};
        }
        if (q0 == 0.0) {
            Complex nonZeroRoot = new Complex(-q1);
            return new Complex[]{q1 > 0.0 ? Complex.ZERO : nonZeroRoot, q1 <= 0.0 ? nonZeroRoot : Complex.ZERO};
        }
        if (q1 == 0.0) {
            double x2 = Math.sqrt(Math.abs(q0));
            if (q0 < 0.0) {
                return new Complex[]{new Complex(x2, 0.0), new Complex(-x2, 0.0)};
            }
            return new Complex[]{new Complex(0.0, x2), new Complex(0.0, -x2)};
        }
        double sqrtLPN = Math.sqrt(Double.MAX_VALUE);
        boolean bl = rescale = q1 > sqrtLPN + sqrtLPN;
        if (!rescale) {
            x = q1 * 0.5;
            boolean bl2 = rescale = q0 < x * x - Double.MAX_VALUE;
        }
        if (rescale) {
            x = Math.abs(q1);
            if (x > (y = Math.sqrt(Math.abs(q0)))) {
                k = x;
                z = 1.0 / x;
                a1 = PolynomialRoots2.sign(1.0, q1);
                a0 = q0 * z * z;
            } else {
                k = y;
                a1 = q1 / y;
                a0 = PolynomialRoots2.sign(1.0, q0);
            }
        } else {
            a1 = q1;
            a0 = q0;
        }
        x = a1 * 0.5;
        y = x * x - a0;
        if (y >= 0.0) {
            y = Math.sqrt(y);
            y = x > 0.0 ? -x - y : -x + y;
            z = rescale ? q0 / (y *= k) : a0 / y;
            return new Complex[]{new Complex(Math.max(y, z), 0.0), new Complex(Math.min(y, z), 0.0)};
        }
        y = Math.sqrt(-y);
        if (rescale) {
            x *= k;
            y *= k;
        }
        return new Complex[]{new Complex(-x, y), new Complex(-x, -y)};
    }

    public static Complex[] cubicRootsNewtonFactor(double a3, double a2, double a1, double a0) {
        double a;
        double b;
        double c;
        if (a3 == 0.0) {
            return PolynomialRoots2.quadraticRoots(a2, a1, a0);
        }
        if (a0 == 0.0) {
            Complex[] result = PolynomialRoots2.quadraticRoots(a3, a2, a1);
            if (result.length == 0) {
                return new Complex[]{Complex.ZERO, Complex.ZERO, Complex.ZERO};
            }
            if (result.length == 1) {
                return new Complex[]{Complex.ZERO, Complex.ZERO, result[0]};
            }
            return new Complex[]{Complex.ZERO, result[0], result[1]};
        }
        double argmax = PolynomialRoots2.maxAbs(a3, a2, a1, a0);
        double d = a0 / argmax;
        double[] args = new double[]{d, c = a1 / argmax, b = a2 / argmax, a = a3 / argmax};
        double root1 = PolynomialRoots2.rootNewtonRaphson(args, 0.0);
        if (Double.isNaN(root1) || PolynomialRoots2.f(args, root1) > 1.0E-9) {
            int s2;
            int s1;
            double min = -64.0;
            double max = 64.0;
            do {
                min *= 2.0;
                if ((max *= 2.0) > 1.0E64) {
                    throw new RuntimeException(String.format("cannot find first root for %fx^3 + %fx^2 + %fx + %f = 0", a, b, c, d));
                }
                s1 = (int)Math.signum(PolynomialRoots2.f(args, min));
                s2 = (int)Math.signum(PolynomialRoots2.f(args, max));
            } while (s1 != 0 && s2 != 0 && s1 == s2);
            root1 = PolynomialRoots2.rootBisection(args, min, max, 0.0);
        }
        Complex[] rootsQuadaratic = PolynomialRoots2.quadraticRoots(a, b + root1 * a, c + root1 * (b + root1 * a));
        return new Complex[]{new Complex(root1), rootsQuadaratic[0], rootsQuadaratic[1]};
    }

    public static Complex[] cubicRootsCardano(double a, double b, double c, double d) {
        if (a == 0.0) {
            return PolynomialRoots2.quadraticRoots(b, c, d);
        }
        if (d == 0.0) {
            Complex[] result = PolynomialRoots2.quadraticRoots(a, b, c);
            if (result.length == 0) {
                return new Complex[]{Complex.ZERO, Complex.ZERO, Complex.ZERO};
            }
            if (result.length == 1) {
                return new Complex[]{Complex.ZERO, Complex.ZERO, result[0]};
            }
            return new Complex[]{Complex.ZERO, result[0], result[1]};
        }
        double D0 = b * b - 3.0 * a * c;
        double D1 = 2.0 * b * b * b - 9.0 * a * b * c + 27.0 * a * a * d;
        if (D0 == 0.0 && D1 == 0.0) {
            Complex root = new Complex(PolynomialRoots2.rootNewtonRaphson(new double[]{d, c, b, a}, 0.0));
            return new Complex[]{root, root, root};
        }
        Complex r = ComplexMath.sqrt(new Complex(D1 * D1 - 4.0 * D0 * D0 * D0));
        Complex s = r.plus(D1).times(0.5);
        if (s.re == 0.0 && s.im == 0.0) {
            s = r.times(-1.0).plus(D1).times(0.5);
        }
        Complex C = ComplexMath.cbrt(s);
        Complex x1 = C.plus(b).plus(C.reciprocal().times(D0)).times(-1.0 / (3.0 * a));
        Complex x2 = C.rotate(Math.toRadians(120.0)).plus(b).plus(C.rotate(Math.toRadians(120.0)).reciprocal().times(D0)).times(-1.0 / (3.0 * a));
        Complex x3 = C.rotate(Math.toRadians(-120.0)).plus(b).plus(C.rotate(Math.toRadians(-120.0)).reciprocal().times(D0)).times(-1.0 / (3.0 * a));
        return new Complex[]{x1, x2, x3};
    }

    public static Complex[] cubicRootsDurandKerner(double a3, double a2, double a1, double a0) {
        if (a3 == 0.0) {
            return PolynomialRoots2.quadraticRoots(a2, a1, a0);
        }
        return PolynomialRoots2.rootsDurandKerner(new Complex[]{new Complex(a0 / a3), new Complex(a1 / a3), new Complex(a2 / a3), Complex.ONE});
    }

    public static Complex[] cubicRootsAberthEhrlich(double a3, double a2, double a1, double a0) {
        if (a3 == 0.0) {
            return PolynomialRoots2.quadraticRoots(a2, a1, a0);
        }
        return PolynomialRoots2.rootsAberthEhrlich(new Complex[]{new Complex(a0 / a3), new Complex(a1 / a3), new Complex(a2 / a3), Complex.ONE});
    }

    public static Complex[] quarticRootsDurandKerner(double a4, double a3, double a2, double a1, double a0) {
        if (a4 == 0.0) {
            return PolynomialRoots2.cubicRootsDurandKerner(a3, a2, a1, a0);
        }
        return PolynomialRoots2.rootsDurandKerner(new Complex[]{new Complex(a0 / a4), new Complex(a1 / a4), new Complex(a2 / a4), new Complex(a3 / a4), Complex.ONE});
    }

    public static Complex[] quarticRootsAberthEhrlich(double a4, double a3, double a2, double a1, double a0) {
        if (a4 == 0.0) {
            return PolynomialRoots2.cubicRootsAberthEhrlich(a3, a2, a1, a0);
        }
        return PolynomialRoots2.rootsAberthEhrlich(new Complex[]{new Complex(a0 / a4), new Complex(a1 / a4), new Complex(a2 / a4), new Complex(a3 / a4), Complex.ONE});
    }

    public static Complex[] rootsDurandKerner(Complex[] a) {
        int i;
        int n = a.length - 1;
        double radius = 1.0 + PolynomialRoots2.maxAbs(a);
        Complex[] p = new Complex[n];
        p[0] = new Complex(Math.sqrt(radius), Math.cbrt(radius));
        double rot = 350.123 / (double)n;
        for (int i2 = 1; i2 < n; ++i2) {
            p[i2] = p[0].rotate(rot * (double)i2);
        }
        double maxError = 1.0;
        int count = 0;
        while (maxError > 0.0 && count < 100) {
            maxError = 0.0;
            ++count;
            for (i = 0; i < n; ++i) {
                Complex factors = Complex.ONE;
                for (int j = 0; j < n; ++j) {
                    if (i == j) continue;
                    factors = factors.times(p[i].minus(p[j]));
                }
                Complex newValue = p[i].minus(PolynomialRoots2.f(a, p[i]).divideBy(factors));
                if (newValue.equals(p[i])) continue;
                double error = newValue.minus(p[i]).norm();
                if (error > maxError) {
                    maxError = error;
                }
                p[i] = newValue;
            }
        }
        for (i = 0; i < n; ++i) {
            if (Math.abs(p[i].im) == Double.MIN_VALUE) {
                p[i] = new Complex(p[i].re, 0.0);
            }
            if (Math.abs(p[i].re) != Double.MIN_VALUE) continue;
            p[i] = new Complex(0.0, p[i].im);
        }
        return p;
    }

    public static Complex[] rootsAberthEhrlich(Complex[] a) {
        int i;
        int n = a.length - 1;
        double radius = 1.0 + PolynomialRoots2.maxAbs(a);
        Complex[] p = new Complex[n];
        p[0] = new Complex(Math.sqrt(radius), Math.cbrt(radius));
        double rot = 350.123 / (double)n;
        for (int i2 = 1; i2 < n; ++i2) {
            p[i2] = p[0].rotate(rot * (double)i2);
        }
        double maxError = 1.0;
        int count = 0;
        while (maxError > 0.0 && count < 100) {
            maxError = 0.0;
            ++count;
            for (i = 0; i < n; ++i) {
                Complex sum = Complex.ZERO;
                for (int j = 0; j < n; ++j) {
                    if (i == j) continue;
                    sum = sum.plus(Complex.ONE.divideBy(p[i].minus(p[j])));
                }
                Complex pDivPDer = PolynomialRoots2.f(a, p[i]).divideBy(PolynomialRoots2.fDerivative(a, p[i]));
                Complex w = pDivPDer.divideBy(Complex.ONE.minus(pDivPDer.times(sum)));
                double error = w.norm();
                if (error > maxError) {
                    maxError = error;
                }
                p[i] = p[i].minus(w);
            }
        }
        for (i = 0; i < n; ++i) {
            if (Math.abs(p[i].im) == Double.MIN_VALUE) {
                p[i] = new Complex(p[i].re, 0.0);
            }
            if (Math.abs(p[i].re) != Double.MIN_VALUE) continue;
            p[i] = new Complex(0.0, p[i].im);
        }
        return p;
    }

    public static double rootNewtonRaphson(double[] a, double allowedError) {
        double x = 0.1232232323234;
        double newValue = Double.NaN;
        double fx = -1.0;
        for (int j = 0; j < 100; ++j) {
            fx = PolynomialRoots2.f(a, x);
            newValue = x - fx / PolynomialRoots2.fDerivative(a, x);
            if (x == newValue || Math.abs(fx) <= allowedError) {
                return x;
            }
            x = newValue;
        }
        return Math.abs(fx) <= allowedError ? x : Double.NaN;
    }

    public static double rootBisection(double[] a, double startMin, double startMax, double allowedError) {
        double xPrev = startMin;
        double min = startMin;
        double max = startMax;
        double fmin = PolynomialRoots2.f(a, min);
        for (int n = 0; n <= 100; ++n) {
            double x = (min + max) / 2.0;
            double fx = PolynomialRoots2.f(a, x);
            if (x == xPrev || Math.abs(fx) < allowedError) {
                return x;
            }
            if (Math.signum(fx) == Math.signum(fmin)) {
                min = x;
                fmin = fx;
            } else {
                max = x;
            }
            xPrev = x;
        }
        return Double.NaN;
    }

    private static double maxAbs(Complex[] array) {
        double m = Double.NEGATIVE_INFINITY;
        for (Complex c : array) {
            if (!(c.norm() > m)) continue;
            m = c.norm();
        }
        return m;
    }

    private static double maxAbs(double ... values) {
        double m = Double.NEGATIVE_INFINITY;
        for (double d : values) {
            if (!(Math.abs(d) > m)) continue;
            m = Math.abs(d);
        }
        return m;
    }

    private static Complex f(Complex[] a, Complex c) {
        Complex cPow = Complex.ONE;
        Complex result = Complex.ZERO;
        for (int i = 0; i < a.length; ++i) {
            result = result.plus(cPow.times(a[i]));
            cPow = cPow.times(c);
        }
        return result;
    }

    private static double f(double[] a, double x) {
        double xPow = 1.0;
        double result = 0.0;
        for (int i = 0; i < a.length; ++i) {
            result += xPow * a[i];
            xPow *= x;
        }
        return result;
    }

    private static Complex f(double[] a, Complex c) {
        Complex cPow = Complex.ONE;
        Complex result = Complex.ZERO;
        for (int i = 0; i < a.length; ++i) {
            result = result.plus(cPow.times(a[i]));
            cPow = cPow.times(c);
        }
        return result;
    }

    private static double fDerivative(double[] a, double x) {
        double xPow = 1.0;
        double result = 0.0;
        for (int i = 1; i < a.length; ++i) {
            result += xPow * (double)i * a[i];
            xPow *= x;
        }
        return result;
    }

    private static Complex fDerivative(Complex[] a, Complex c) {
        Complex cPow = Complex.ONE;
        Complex result = Complex.ZERO;
        for (int i = 1; i < a.length; ++i) {
            result = result.plus(cPow.times(a[i]).times(i));
            cPow = cPow.times(c);
        }
        return result;
    }

    public static void main(String[] args) {
        Complex[] roots;
        double a = 0.001;
        double b = 1000.0;
        double c = 0.0;
        double d = 1.0;
        for (Complex root : roots = PolynomialRoots2.cubicRootsNewtonFactor(a, b, c, d)) {
            System.out.println("NewtonFactor    " + root + "   f(x) = " + PolynomialRoots2.f(new double[]{d, c, b, a}, root));
        }
        System.out.println();
        for (Complex root : roots = PolynomialRoots2.cubicRootsCardano(a, b, c, d)) {
            System.out.println("Cardano         " + root + "   f(x) = " + PolynomialRoots2.f(new double[]{d, c, b, a}, root));
        }
        System.out.println();
        for (Complex root : roots = PolynomialRoots2.cubicRootsAberthEhrlich(a, b, c, d)) {
            System.out.println("Aberth-Ehrlich  " + root + "   f(x) = " + PolynomialRoots2.f(new double[]{d, c, b, a}, root));
        }
        System.out.println();
        for (Complex root : roots = PolynomialRoots2.cubicRootsDurandKerner(a, b, c, d)) {
            System.out.println("Durand-Kerner   " + root + "   f(x) = " + PolynomialRoots2.f(new double[]{d, c, b, a}, root));
        }
        System.out.println();
        for (Complex root : roots = PolynomialRoots.cubicRoots(a, b, c, d)) {
            System.out.println("F77             " + root + "   f(x) = " + PolynomialRoots2.f(new double[]{d, c, b, a}, root));
        }
    }
}

