/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.rmi;

import java.net.URL;
import java.rmi.AlreadyBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.djutils.exceptions.Throw;
import org.djutils.rmi.RmiRegistry;

public class RmiObject
extends UnicastRemoteObject {
    private static final long serialVersionUID = 20200111L;
    private Registry registry;

    public RmiObject(URL registryURL, String bindingKey) throws RemoteException, AlreadyBoundException {
        Throw.whenNull(registryURL, "registryURL cannot be null");
        Throw.whenNull(bindingKey, "bindingKey cannot be null");
        String host = registryURL.getHost() == null ? "127.0.0.1" : registryURL.getHost();
        int port = registryURL.getPort() == -1 ? 1099 : registryURL.getPort();
        this.register(host, port, bindingKey);
    }

    public RmiObject(String host, int port, String bindingKey) throws RemoteException, AlreadyBoundException {
        this.register(host, port, bindingKey);
    }

    protected void register(String host, int port, String bindingKey) throws RemoteException, AlreadyBoundException {
        Throw.whenNull(bindingKey, "bindingKey cannot be null");
        this.registry = RmiRegistry.getRegistry(host, port);
        RmiRegistry.bind(this.registry, bindingKey, this);
    }

    public Registry getRegistry() throws RemoteException {
        return this.registry;
    }
}

