/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.traceverifier;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.djutils.traceverifier.TraceVerifierException;

public class TraceVerifier
implements Closeable {
    private final String outputFileName;
    private final BufferedReader reader;

    public TraceVerifier(String fileName) throws IOException {
        File traceFile = new File(fileName);
        if (traceFile.exists()) {
            this.reader = new BufferedReader(new FileReader(fileName));
            this.outputFileName = null;
        } else {
            this.outputFileName = fileName;
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            writer.close();
            this.reader = null;
        }
    }

    public void sample(String description, String state) throws IOException {
        String got = String.format("%s: %s", description, state);
        if (this.reader != null) {
            String expected = this.reader.readLine();
            if (expected.equals(got)) {
                return;
            }
            int indexOfFirstDifference = 0;
            while (got.charAt(indexOfFirstDifference) == expected.charAt(indexOfFirstDifference)) {
                ++indexOfFirstDifference;
            }
            String format = indexOfFirstDifference == 0 ? "Discrepancy found.\n%%-8.8s: \"%%s\"\n%%-8.8s: \"%%s\"\n%%-8.8s:  %%s^" : String.format("Discrepancy found.\n%%-8.8s: \"%%s\"\n%%-8.8s: \"%%s\"\n%%-8.8s:  %%%d.%ds^", indexOfFirstDifference, indexOfFirstDifference);
            String error = String.format(format, "Got", got, "Expected", expected, "1st diff", "");
            throw new TraceVerifierException(error);
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(this.outputFileName, true));
        writer.append(got);
        writer.append('\n');
        writer.close();
    }

    @Override
    public void close() throws IOException {
        if (null != this.reader) {
            this.reader.close();
        }
    }

    public String toString() {
        return "TraceVerifier [reader=" + this.reader + ", outputFileName=" + this.outputFileName + "]";
    }
}

