/*
 * Decompiled with CFR 0.152.
 */
package org.djutils.buildtools;

import com.github.javaparser.JavaParser;
import com.github.javaparser.Position;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.CallableDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;

public class ParamComments {
    private List<String> lines;
    private boolean changed;

    public static void main(String[] args) throws IOException, URISyntaxException {
        new ParamComments();
    }

    public ParamComments() throws IOException, URISyntaxException {
        File classFolder = new File(ParamComments.class.getResource("/").toURI());
        File workspaceFolder = classFolder.getParentFile().getParentFile().getParentFile();
        for (File projectFolder : workspaceFolder.listFiles()) {
            if (!projectFolder.isDirectory() || !projectFolder.getName().startsWith("djutils") || !new File(projectFolder, "src/main/java").exists()) continue;
            File sourcePathFile = new File(projectFolder, "src/main/java");
            for (File srcFolder : sourcePathFile.listFiles()) {
                this.processDirOrFile(srcFolder);
            }
        }
    }

    private void processDirOrFile(File srcFolder) throws IOException {
        if (srcFolder.isDirectory()) {
            for (File subFile : srcFolder.listFiles()) {
                if (subFile.isDirectory()) {
                    this.processDirOrFile(subFile);
                    continue;
                }
                if (!subFile.getName().endsWith(".java") || subFile.getName().startsWith("package-info")) continue;
                this.processJavaFile(subFile);
            }
        }
    }

    private void processJavaFile(File javaFile) throws IOException {
        System.out.println("\n" + javaFile.toURI().getPath());
        this.changed = false;
        this.lines = Files.readAllLines(Paths.get(javaFile.toURI()), StandardCharsets.UTF_8);
        FileInputStream in = new FileInputStream(javaFile.toURI().getPath());
        CompilationUnit cu = JavaParser.parse((InputStream)in);
        cu.accept((VoidVisitor)new CodeVisitor(this), null);
        if (this.changed) {
            Files.write(Paths.get(javaFile.toURI()), this.lines, new OpenOption[0]);
            System.out.println("CHANGED AND WRITTEN: " + javaFile.toString());
        }
    }

    public final boolean isChanged() {
        return this.changed;
    }

    public final void setChanged(boolean changed) {
        this.changed = changed;
    }

    public final List<String> getLines() {
        return this.lines;
    }

    protected static class CodeVisitor
    extends VoidVisitorAdapter<Void> {
        private ParamComments paramComments;

        protected CodeVisitor(ParamComments paramComments) {
            this.paramComments = paramComments;
        }

        public void visit(ConstructorDeclaration constructorDeclaration, Void arg) {
            System.out.println("\n------\nCONSTRUCTOR\n   " + constructorDeclaration.getName() + " : " + constructorDeclaration.getDeclarationAsString());
            this.processDeclaration((CallableDeclaration<?>)constructorDeclaration);
            super.visit(constructorDeclaration, (Object)arg);
        }

        public void visit(MethodDeclaration methodDeclaration, Void arg) {
            System.out.println("\n------\n   " + methodDeclaration.getName() + " : " + methodDeclaration.getTypeAsString());
            this.processDeclaration((CallableDeclaration<?>)methodDeclaration);
            super.visit(methodDeclaration, (Object)arg);
        }

        private void processDeclaration(CallableDeclaration<?> callableDeclaration) {
            for (Parameter parameter : callableDeclaration.getParameters()) {
                System.out.println("      " + parameter.getNameAsString() + " : " + parameter.getTypeAsString() + (parameter.isVarArgs() ? "..." : ""));
            }
            if (callableDeclaration.getComment().isPresent()) {
                System.out.print(callableDeclaration.getComment().get());
                String parserComment = ((Comment)callableDeclaration.getComment().get()).toString();
                if (parserComment.contains("@param") && ((Comment)callableDeclaration.getComment().get()).toJavadocComment().isPresent()) {
                    String[] commentLines;
                    JavadocComment comment = (JavadocComment)((Comment)callableDeclaration.getComment().get()).toJavadocComment().get();
                    for (String string : commentLines = parserComment.split("\n")) {
                        if (!string.contains("@param") || string.contains("@param <")) continue;
                        int fileLine = -1;
                        for (int lnr = 0; lnr < commentLines.length; ++lnr) {
                            if (!this.paramComments.getLines().get(((Position)comment.getBegin().get()).line + lnr).trim().equals(string.trim())) continue;
                            fileLine = ((Position)comment.getBegin().get()).line + lnr;
                        }
                        if (fileLine == -1) {
                            System.out.println("COULD NOT FIND LINE FROM COMMENT IN FILE LINES...");
                            break;
                        }
                        String string2 = string.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
                        String noHtmlLine = string2.replaceAll("&\\w+;", "");
                        int paramIndex = string2.indexOf("@param");
                        int varEndIndex = string2.indexOf(32, paramIndex + 7) == -1 ? string2.length() : string2.indexOf(32, paramIndex + 7);
                        String varName = string2.substring(paramIndex + 6, varEndIndex).trim();
                        boolean found = false;
                        for (Parameter parameter : callableDeclaration.getParameters()) {
                            Object parameterType;
                            if (!parameter.getNameAsString().equals(varName)) continue;
                            String varType = "";
                            if (noHtmlLine.indexOf(";", varEndIndex + 1) != -1) {
                                varType = noHtmlLine.substring(varEndIndex + 1, noHtmlLine.indexOf(59, varEndIndex + 1)).trim().replaceAll(", ", ",");
                                if (!varType.equals(parameterType = parameter.getType().asString() + (parameter.isVarArgs() ? "..." : ""))) {
                                    if (varType.contains(" ")) {
                                        System.out.println("NO CHANGE - SPACES IN TYPE : " + string2.replaceAll("<", "&lt;").replaceAll(">", "&gt;").trim());
                                    } else {
                                        parameterType = ((String)parameterType).replaceAll(",", ", ");
                                        String string4 = string2.substring(0, varEndIndex) + " " + (String)parameterType + string2.substring(string2.indexOf(";", varEndIndex + 1));
                                        string4 = string4.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                                        System.out.println("CHANGED TYPE : " + string4.trim());
                                        this.paramComments.setChanged(true);
                                        this.paramComments.getLines().set(fileLine, string4.replaceAll("\\n", ""));
                                    }
                                }
                            } else {
                                parameterType = parameter.getType().asString() + (parameter.isVarArgs() ? "..." : "").replaceAll(",", ", ");
                                String string6 = string2.substring(0, varEndIndex) + " " + (String)parameterType + "; " + string2.substring(Math.min(varEndIndex + 1, string2.length() - 1));
                                string6 = string6.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                                System.out.println("ADDED TYPE : " + string6.trim());
                                this.paramComments.setChanged(true);
                                this.paramComments.getLines().set(fileLine, string6.replaceAll("\\n", ""));
                            }
                            found = true;
                            break;
                        }
                        if (found) continue;
                        System.out.println("XXXXXXXX @param comment for " + varName + " does not match any parameters in method");
                    }
                }
            }
        }
    }
}

