/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.gitversion.dsl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.dmfs.gitversion.git.changetypefacories.Condition;
import org.dmfs.gitversion.git.changetypefacories.condition.AllOf;
import org.dmfs.gitversion.git.changetypefacories.condition.Branch;
import org.dmfs.gitversion.git.changetypefacories.condition.CommitMessage;
import org.dmfs.gitversion.git.changetypefacories.condition.CommitTitle;
import org.dmfs.gitversion.git.predicates.Contains;
import org.dmfs.gitversion.git.predicates.Matches;
import org.dmfs.gradle.gitversion.git.changetypefacories.condition.Affects;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class Conditions
implements Condition {
    private final List<Condition> mConditions = new ArrayList<Condition>();

    public void commitTitle(Predicate<? super String> predicate) {
        this.mConditions.add(new CommitTitle(predicate));
    }

    public void commitMessage(Predicate<? super String> predicate) {
        this.mConditions.add(new CommitMessage(predicate));
    }

    public void branch(Predicate<? super String> predicate) {
        this.mConditions.add(new Branch(predicate));
    }

    public void affects(Predicate<? super Set<String>> predicate) {
        this.mConditions.add(new Affects(predicate));
    }

    @SafeVarargs
    public static Predicate<Set<String>> anyThat(Predicate<String> ... delegates) {
        return set -> Arrays.stream(delegates).anyMatch(stringPredicate -> set.stream().anyMatch(stringPredicate));
    }

    @SafeVarargs
    public static Predicate<Set<String>> noneThat(Predicate<String> ... delegates) {
        return set -> Arrays.stream(delegates).noneMatch(stringPredicate -> set.stream().anyMatch(stringPredicate));
    }

    @SafeVarargs
    public static Predicate<Set<String>> only(Predicate<String> ... delegates) {
        return set -> set.stream().allMatch(string -> Arrays.stream(delegates).anyMatch(stringPredicate -> stringPredicate.test(string)));
    }

    @Deprecated
    public static Predicate<CharSequence> contains(String pattern) {
        return new Contains(pattern);
    }

    public static Predicate<CharSequence> contains(Pattern pattern) {
        return new Contains(pattern);
    }

    @Deprecated
    public static Predicate<CharSequence> matches(String pattern) {
        return new Matches(pattern);
    }

    public static Predicate<CharSequence> matches(Pattern pattern) {
        return new Matches(pattern);
    }

    @Override
    public boolean matches(Repository repository, RevCommit commit, String branch) {
        return new AllOf(this.mConditions).matches(repository, commit, branch);
    }
}

