/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.gitversion.dsl;

import groovy.lang.Closure;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dmfs.gitversion.dsl.IssueTracker;
import org.dmfs.gitversion.dsl.PreReleaseConfig;
import org.dmfs.gitversion.dsl.RegExDsl;
import org.dmfs.gitversion.dsl.Strategy;
import org.dmfs.gitversion.dsl.issuetracker.GitHub;
import org.dmfs.gitversion.dsl.issuetracker.Gitea;
import org.dmfs.gitversion.git.Suffixes;

public class GitVersionConfig {
    public Strategy mChangeTypeStrategy = new Strategy();
    public Optional<IssueTracker> issueTracker = Optional.empty();
    public Pattern mReleaseBranchPattern = Pattern.compile("(main|master)$");
    public PreReleaseConfig mPreReleaseStrategies = new PreReleaseConfig();
    public Suffixes mSuffixes = new Suffixes();

    public void setIssueTracker(IssueTracker issueTracker) {
        this.issueTracker = Optional.of(issueTracker);
    }

    public IssueTracker GitHub(Closure<?> closure) {
        GitHub issueTracker = new GitHub();
        closure.setResolveStrategy(1);
        closure.setDelegate((Object)issueTracker);
        closure.call();
        return issueTracker;
    }

    public IssueTracker Gitea(Closure<?> closure) {
        Gitea issueTracker = new Gitea();
        closure.setResolveStrategy(1);
        closure.setDelegate((Object)issueTracker);
        closure.call();
        return issueTracker;
    }

    public void setReleaseBranchPattern(Pattern releaseBranchPattern) {
        this.mReleaseBranchPattern = releaseBranchPattern;
    }

    public void changes(Closure<?> closure) {
        closure.setResolveStrategy(1);
        closure.setDelegate((Object)this.mChangeTypeStrategy);
        closure.call();
    }

    public Predicate<String> contains(Pattern pattern, Closure<Predicate<Matcher>> delegate) {
        delegate.setResolveStrategy(1);
        return s -> {
            Matcher matcher = pattern.matcher((CharSequence)s);
            int pos = 0;
            while (matcher.find(pos)) {
                pos = matcher.end();
                delegate.setDelegate((Object)new RegExDsl(this.issueTracker));
                if (!((Predicate)delegate.call()).test(matcher)) continue;
                return true;
            }
            return false;
        };
    }

    public <T> Predicate<T> not(Predicate<T> delegate) {
        return delegate.negate();
    }

    public void preReleases(Closure<?> closure) {
        closure.setResolveStrategy(1);
        closure.setDelegate((Object)this.mPreReleaseStrategies);
        closure.call();
    }

    public void suffixes(Closure<?> closure) {
        this.mSuffixes.mSuffixes.clear();
        closure.setResolveStrategy(1);
        closure.setDelegate((Object)this.mSuffixes);
        closure.call();
    }
}

