/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.gitversion.dsl.issuetracker;

import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import java.util.Optional;
import java.util.function.Predicate;
import org.dmfs.gitversion.dsl.IssueTracker;
import org.dmfs.gitversion.dsl.issuetracker.GiteaDsl;
import org.dmfs.gitversion.dsl.issuetracker.GiteaIssueFunction;
import org.dmfs.jems2.FragileBiFunction;
import org.dmfs.jems2.FragileFunction;

public final class Gitea
implements IssueTracker {
    private String mHost = "";
    private String mRepo = "";
    public String accessToken = "";
    private final FragileBiFunction<String, Optional<String>, FragileFunction<Integer, String, Exception>, Exception> issueFunction;

    public Gitea() {
        this((FragileBiFunction<String, Optional<String>, FragileFunction<Integer, String, Exception>, Exception>)((FragileBiFunction)(baseUrl, accessToken) -> new GiteaIssueFunction((String)baseUrl, connection -> accessToken.ifPresent(token -> connection.setRequestProperty("Authorization", "token " + token)))));
    }

    public Gitea(FragileBiFunction<String, Optional<String>, FragileFunction<Integer, String, Exception>, Exception> issueFunction) {
        this.issueFunction = issueFunction;
    }

    public void setHost(String host) {
        this.mHost = host;
    }

    public void setRepo(String repo) {
        if (!repo.matches("^[\\w\\d-]+/[\\w\\d_.-]+$")) {
            throw new IllegalArgumentException("Illegal repo name " + repo);
        }
        this.mRepo = repo;
    }

    @Override
    public Predicate<String> containsIssue(Closure<Predicate<Object>> delegate) {
        return issue -> {
            try {
                delegate.setDelegate((Object)new GiteaDsl());
                if (((Predicate)delegate.call()).test(new JsonSlurper().parseText((String)((FragileFunction)this.issueFunction.value((Object)String.format("https://%s/api/v1/repos/%s/issues", this.mHost, this.mRepo), Optional.of(this.accessToken).filter(s -> !s.isEmpty()))).value((Object)Integer.valueOf(issue))))) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        };
    }
}

