/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.gver.dsl.issuetracker;

import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import java.util.Optional;
import java.util.function.Predicate;
import org.dmfs.gver.dsl.IssueTracker;
import org.dmfs.gver.dsl.issuetracker.GitHubDsl;
import org.dmfs.gver.dsl.issuetracker.GitHubIssueFunction;
import org.dmfs.jems2.FragileBiFunction;
import org.dmfs.jems2.FragileFunction;

public final class GitHub
implements IssueTracker {
    private String repo = "";
    public String accessToken = "";
    private final FragileBiFunction<String, Optional<String>, FragileFunction<Integer, String, Exception>, Exception> issueFunction;

    public GitHub() {
        this((FragileBiFunction<String, Optional<String>, FragileFunction<Integer, String, Exception>, Exception>)((FragileBiFunction)(repo, accessToken) -> new GitHubIssueFunction((String)repo, connection -> accessToken.ifPresent(token -> connection.setRequestProperty("Authorization", "token " + token)))));
    }

    public GitHub(FragileBiFunction<String, Optional<String>, FragileFunction<Integer, String, Exception>, Exception> issueFunction) {
        this.issueFunction = issueFunction;
    }

    public void setRepo(String repo) {
        if (!repo.matches("^[\\w\\d-]+/[\\w\\d_.-]+$")) {
            throw new IllegalArgumentException("Illegal repo name " + repo);
        }
        this.repo = repo;
    }

    @Override
    public Predicate<String> containsIssue(Closure<Predicate<Object>> delegate) {
        return issue -> {
            try {
                delegate.setDelegate((Object)new GitHubDsl());
                if (((Predicate)delegate.call()).test(new JsonSlurper().parseText((String)((FragileFunction)this.issueFunction.value((Object)this.repo, Optional.of(this.accessToken).filter(s -> !s.isEmpty()))).value((Object)Integer.valueOf(issue))))) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        };
    }
}

