/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.gver.git;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.dmfs.gver.git.ChangeTypeStrategy;
import org.dmfs.gver.git.Suffixes;
import org.dmfs.jems2.FragileFunction;
import org.dmfs.jems2.Function;
import org.dmfs.jems2.Optional;
import org.dmfs.jems2.comparator.Reverse;
import org.dmfs.jems2.iterable.Mapped;
import org.dmfs.jems2.iterable.Seq;
import org.dmfs.jems2.iterable.Sorted;
import org.dmfs.jems2.optional.First;
import org.dmfs.jems2.optional.FirstPresent;
import org.dmfs.jems2.optional.MapEntry;
import org.dmfs.jems2.optional.NullSafe;
import org.dmfs.jems2.optional.Zipped;
import org.dmfs.jems2.single.Backed;
import org.dmfs.jems2.single.Unchecked;
import org.dmfs.semver.NextPreRelease;
import org.dmfs.semver.PatchPreRelease;
import org.dmfs.semver.PreRelease;
import org.dmfs.semver.Release;
import org.dmfs.semver.StrictParser;
import org.dmfs.semver.Version;
import org.dmfs.semver.comparators.VersionComparator;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public final class GitVersion
implements FragileFunction<Repository, Version, Exception> {
    private final ChangeTypeStrategy mStrategy;
    private final Suffixes mSuffixes;
    private final Function<String, String> mPreReleaseStrategy;

    public GitVersion(ChangeTypeStrategy strategy, Suffixes suffixes, Function<String, String> preReleaseStrategy) {
        this.mStrategy = strategy;
        this.mSuffixes = suffixes;
        this.mPreReleaseStrategy = preReleaseStrategy;
    }

    public Version value(Repository repository) throws Exception {
        try (RevWalk revWalk = new RevWalk(repository);){
            RevCommit head = repository.parseCommit((AnyObjectId)repository.resolve("HEAD"));
            Version version = this.adjustForDirtyRepo(repository, this.readVersion(repository, revWalk, head, this.versions(repository), (String)this.mPreReleaseStrategy.value((Object)repository.getBranch())));
            Version version2 = (Version)new Backed((Optional)new Zipped(version.preRelease(), this.mSuffixes.suffix(repository, head, repository.getBranch()), (current, suffix) -> new PreRelease(version, current + suffix)), (Object)version).value();
            return version2;
        }
    }

    private Version adjustForDirtyRepo(Repository repository, Version version) throws GitAPIException {
        return !new Git(repository).diff().call().isEmpty() || !new Git(repository).diff().setCached(true).call().isEmpty() ? new NextPreRelease(version) : version;
    }

    private Version readVersion(Repository repository, RevWalk revWalk, RevCommit commit, Map<ObjectId, Version> tags, String preRelease) {
        return (Version)new Backed((Optional)new FirstPresent(new Optional[]{new MapEntry(tags, (Object)commit.getId()), new First((Iterable)new Sorted((Comparator)new Reverse((Comparator)new VersionComparator()), (Iterable)new Mapped(v -> this.mStrategy.changeType(repository, commit, (String)new Unchecked(() -> ((Repository)repository).getBranch()).value()).value((Version)v, preRelease), (Iterable)new Mapped(commit1 -> this.readVersion(repository, revWalk, (RevCommit)commit1, tags, preRelease), (Iterable)new Seq((Object[])this.parsed(revWalk, commit).getParents())))))}), () -> new PatchPreRelease((Version)new Release(0, 0, 0), preRelease)).value();
    }

    private RevCommit parsed(RevWalk revWalk, RevCommit commit) {
        try {
            return revWalk.parseCommit((AnyObjectId)commit.getId());
        }
        catch (IOException e) {
            throw new RuntimeException("Can't parse commit", e);
        }
    }

    private Map<ObjectId, Version> versions(Repository repository) throws GitAPIException, IOException {
        StrictParser parser = new StrictParser();
        HashMap<ObjectId, Version> result = new HashMap<ObjectId, Version>();
        RefDatabase refDatabase = repository.getRefDatabase();
        for (Ref tag : new Git(repository).tagList().call()) {
            try {
                String tagName = tag.getName().startsWith("refs/tags/") ? tag.getName().substring("refs/tags/".length()) : tag.getName();
                Version version = parser.parse((CharSequence)tagName);
                Ref peeled = refDatabase.peel(tag);
                ObjectId objectId = (ObjectId)new Backed((Optional)new NullSafe((Object)peeled.getPeeledObjectId()), (Object)peeled.getObjectId()).value();
                if (result.containsKey(objectId) && new VersionComparator().compare((Object)((Version)result.get(objectId)), (Object)version) >= 0) continue;
                result.put(objectId, version);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return result;
    }
}

