/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.gver.git;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.dmfs.gver.dsl.Conditions;
import org.dmfs.gver.dsl.SuffixPattern;
import org.dmfs.gver.dsl.SuffixStrategy;
import org.dmfs.gver.git.predicates.IsDirty;
import org.dmfs.jems2.Optional;
import org.dmfs.jems2.optional.Absent;
import org.dmfs.jems2.optional.FirstPresent;
import org.dmfs.jems2.optional.Mapped;
import org.dmfs.jems2.optional.Present;
import org.dmfs.rfc5545.DateTime;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public final class Suffixes {
    private static final Supplier<SuffixStrategy> DEFAULT_STRATEGY = () -> (repository, commit, branch) -> new Present((Object)("." + (new IsDirty().satisfiedBy(repository) ? DateTime.now() : new DateTime((long)commit.getCommitTime() * 1000L)) + "-SNAPSHOT"));
    public final List<SuffixStrategy> mSuffixes = new ArrayList<SuffixStrategy>(InvokerHelper.asList((Object)DEFAULT_STRATEGY.get()));
    public static final String DEFAULT = "\u0000";

    public SuffixPattern append(String suffix) {
        SuffixStrategy defaultStrategy = DEFAULT.equals(suffix) ? DEFAULT_STRATEGY.get() : (repository, commit, branch) -> new Present((Object)suffix);
        this.mSuffixes.add(defaultStrategy);
        return condition -> {
            Conditions conditions = new Conditions();
            condition.setResolveStrategy(1);
            condition.setDelegate((Object)conditions);
            condition.call();
            this.mSuffixes.set(this.mSuffixes.indexOf(defaultStrategy), (repository, commit, branches) -> conditions.matches(repository, commit, branches) ? new Present((Object)suffix) : Absent.absent());
        };
    }

    Optional<String> suffix(Repository repository, RevCommit commit, String branch) {
        return new Mapped(suffix -> suffix.replace('_', '-').replaceAll("[^.a-zA-Z0-9-]", ""), (Optional)new FirstPresent((Iterable)new org.dmfs.jems2.iterable.Mapped(suffixStrategy -> suffixStrategy.changeType(repository, commit, branch), this.mSuffixes)));
    }
}

