/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.gver.dsl;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.dmfs.gver.dsl.ConditionConsumer;
import org.dmfs.gver.dsl.Conditions;
import org.dmfs.gver.git.ChangeType;
import org.dmfs.gver.git.ChangeTypeStrategy;

public class Strategy {
    public final List<ChangeTypeStrategy> mChangeTypeStrategies;
    public static final ChangeType major = ChangeType.MAJOR;
    public static final ChangeType minor = ChangeType.MINOR;
    public static final ChangeType patch = ChangeType.PATCH;
    public static final ChangeType none = ChangeType.NONE;
    public static final ChangeType invalid = ChangeType.INVALID;

    public Strategy() {
        this(new ChangeTypeStrategy[0]);
    }

    public Strategy(ChangeTypeStrategy ... strategies) {
        this.mChangeTypeStrategies = new ArrayList<ChangeTypeStrategy>(InvokerHelper.asList((Object)strategies));
    }

    public ConditionConsumer are(ChangeType changeType) {
        return condition -> {
            Conditions conditions = new Conditions();
            condition.setResolveStrategy(1);
            condition.setDelegate((Object)conditions);
            condition.call();
            this.mChangeTypeStrategies.add(changeType.when(conditions));
        };
    }

    public void otherwise(ChangeType changeType) {
        this.mChangeTypeStrategies.add(changeType.when((repository, commit, branches) -> true));
    }

    public void follow(Closure strategy) {
        strategy.setResolveStrategy(1);
        strategy.setDelegate((Object)this);
        strategy.call();
    }
}

