/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.gver.git.changetypefacories.condition;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.dmfs.gver.git.changetypefacories.Condition;
import org.dmfs.jems2.Optional;
import org.dmfs.jems2.iterable.PresentValues;
import org.dmfs.jems2.optional.NullSafe;
import org.dmfs.jems2.procedure.ForEach;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.EmptyTreeIterator;

public final class Affects
implements Condition {
    private final Predicate<? super Set<String>> mPredicate;

    public Affects(Predicate<? super Set<String>> predicate) {
        this.mPredicate = predicate;
    }

    @Override
    public boolean matches(Repository repository, RevCommit commit, String branch) {
        HashSet files = new HashSet();
        try (Git git = new Git(repository);){
            boolean bl;
            block11: {
                ObjectReader reader = repository.newObjectReader();
                try {
                    Object[] parents = commit.getParents();
                    CanonicalTreeParser oldTreeIter = new CanonicalTreeParser();
                    CanonicalTreeParser newTreeIter = new CanonicalTreeParser();
                    new ForEach(parents).process(parent -> {
                        try {
                            if (parent.getTree() == null) {
                                parent = repository.parseCommit((AnyObjectId)parent.getId());
                            }
                            if (parent.getTree() != null) {
                                oldTreeIter.reset(reader, (AnyObjectId)parent.getTree().toObjectId());
                            }
                            if (commit.getTree() != null) {
                                newTreeIter.reset(reader, (AnyObjectId)commit.getTree().toObjectId());
                            }
                            List changes = git.diff().setNewTree((AbstractTreeIterator)(commit.getTree() != null ? newTreeIter : new EmptyTreeIterator())).setOldTree((AbstractTreeIterator)(parent.getTree() != null ? oldTreeIter : new EmptyTreeIterator())).call();
                            changes.forEach(de -> new ForEach((Iterable)new PresentValues(new Optional[]{new NullSafe((Object)de.getNewPath()), new NullSafe((Object)de.getOldPath())})).process(files::add));
                        }
                        catch (IOException | GitAPIException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    bl = this.mPredicate.test(files);
                    if (reader == null) break block11;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return bl;
        }
    }
}

