/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.gver.dsl;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.dmfs.gver.git.changetypefacories.Condition;
import org.dmfs.gver.git.changetypefacories.condition.Affects;
import org.dmfs.gver.git.changetypefacories.condition.AllOf;
import org.dmfs.gver.git.changetypefacories.condition.AnyOf;
import org.dmfs.gver.git.changetypefacories.condition.Branch;
import org.dmfs.gver.git.changetypefacories.condition.CommitMessage;
import org.dmfs.gver.git.changetypefacories.condition.CommitTitle;
import org.dmfs.gver.git.changetypefacories.condition.EnvVariable;
import org.dmfs.gver.git.predicates.Contains;
import org.dmfs.gver.git.predicates.Matches;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class Conditions
implements Condition {
    private final List<Condition> mConditions = new ArrayList<Condition>();

    public void commitTitle(Predicate<? super String> predicate) {
        this.mConditions.add(new CommitTitle(predicate));
    }

    public void commitMessage(Predicate<? super String> predicate) {
        this.mConditions.add(new CommitMessage(predicate));
    }

    public void branch(Predicate<? super String> predicate) {
        this.mConditions.add(new Branch(predicate));
    }

    public void affects(Predicate<? super Set<String>> predicate) {
        this.mConditions.add(new Affects(predicate));
    }

    public void envVariable(String variableName, Predicate<? super String> predicate) {
        this.mConditions.add(new EnvVariable(variableName, predicate));
    }

    public void anyOf(Closure<?> delegate) {
        Conditions conditions = new Conditions();
        delegate.setDelegate((Object)conditions);
        delegate.setResolveStrategy(1);
        delegate.call();
        this.mConditions.add(new AnyOf(conditions.mConditions));
    }

    @SafeVarargs
    public static Predicate<Set<String>> anyThat(Predicate<String> ... delegates) {
        return set -> Arrays.stream(delegates).anyMatch(stringPredicate -> set.stream().anyMatch(stringPredicate));
    }

    @SafeVarargs
    public static Predicate<Set<String>> noneThat(Predicate<String> ... delegates) {
        return set -> Arrays.stream(delegates).noneMatch(stringPredicate -> set.stream().anyMatch(stringPredicate));
    }

    @SafeVarargs
    public static Predicate<Set<String>> only(Predicate<String> ... delegates) {
        return set -> set.stream().allMatch(string -> Arrays.stream(delegates).anyMatch(stringPredicate -> stringPredicate.test(string)));
    }

    @Deprecated
    public static Predicate<CharSequence> contains(String pattern) {
        return new Contains(pattern);
    }

    public static Predicate<CharSequence> contains(Pattern pattern) {
        return new Contains(pattern);
    }

    @Deprecated
    public static Predicate<CharSequence> matches(String pattern) {
        return new Matches(pattern);
    }

    public static Predicate<CharSequence> matches(Pattern pattern) {
        return new Matches(pattern);
    }

    @Override
    public boolean matches(Repository repository, RevCommit commit, String branch) {
        return new AllOf(this.mConditions).matches(repository, commit, branch);
    }
}

