/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.gver.dsl;

import groovy.lang.Closure;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dmfs.gver.dsl.IssueTracker;
import org.dmfs.gver.dsl.PreReleaseConfig;
import org.dmfs.gver.dsl.RegExDsl;
import org.dmfs.gver.dsl.ReleaseType;
import org.dmfs.gver.dsl.Strategy;
import org.dmfs.gver.dsl.TagConfig;
import org.dmfs.gver.dsl.conventions.ConventionalCommits;
import org.dmfs.gver.dsl.conventions.StrictConventionalCommits;
import org.dmfs.gver.dsl.issuetracker.GitHub;
import org.dmfs.gver.dsl.issuetracker.Gitea;
import org.dmfs.gver.git.Suffixes;
import org.dmfs.gver.git.changetypefacories.condition.Branch;

public class GitVersionConfig {
    public Strategy mChangeTypeStrategy = new Strategy();
    public Optional<IssueTracker> issueTracker = Optional.empty();
    public PreReleaseConfig mPreReleaseStrategies = new PreReleaseConfig();
    public Suffixes mSuffixes = new Suffixes();
    public Closure conventionalCommits = new ConventionalCommits(this);
    public Closure strictConventionalCommits = new StrictConventionalCommits(this);
    public TagConfig mTagConfig = new TagConfig();

    public GitVersionConfig() {
        this.setReleaseBranchPattern(Pattern.compile("main|master"));
    }

    public void setIssueTracker(IssueTracker issueTracker) {
        this.issueTracker = Optional.of(issueTracker);
    }

    public IssueTracker GitHub(Closure<?> closure) {
        GitHub issueTracker = new GitHub();
        closure.setResolveStrategy(1);
        closure.setDelegate((Object)issueTracker);
        closure.call();
        return issueTracker;
    }

    public IssueTracker Gitea(Closure<?> closure) {
        Gitea issueTracker = new Gitea();
        closure.setResolveStrategy(1);
        closure.setDelegate((Object)issueTracker);
        closure.call();
        return issueTracker;
    }

    public void setReleaseBranchPattern(Pattern releaseBranchPattern) {
        this.mTagConfig.mTagMappings.put(new Branch(branch -> releaseBranchPattern.matcher((CharSequence)branch).matches()), ReleaseType.RELEASE);
        this.mTagConfig.mTagMappings.put(new Branch(branch -> releaseBranchPattern.matcher((CharSequence)branch).matches()), ReleaseType.PRERELEASE);
    }

    public void changes(Closure<?> closure) {
        closure.setResolveStrategy(1);
        closure.setDelegate((Object)this.mChangeTypeStrategy);
        closure.call();
    }

    public Predicate<String> contains(Pattern pattern, Closure<Predicate<Matcher>> delegate) {
        delegate.setResolveStrategy(1);
        return s -> {
            Matcher matcher = pattern.matcher((CharSequence)s);
            int pos = 0;
            while (matcher.find(pos)) {
                pos = matcher.end();
                delegate.setDelegate((Object)new RegExDsl(this.issueTracker));
                if (!((Predicate)delegate.call()).test(matcher)) continue;
                return true;
            }
            return false;
        };
    }

    public <T> Predicate<T> not(Predicate<T> delegate) {
        return delegate.negate();
    }

    public void preReleases(Closure<?> closure) {
        closure.setResolveStrategy(1);
        closure.setDelegate((Object)this.mPreReleaseStrategies);
        closure.call();
    }

    public void suffixes(Closure<?> closure) {
        this.mSuffixes.mSuffixes.clear();
        closure.setResolveStrategy(1);
        closure.setDelegate((Object)this.mSuffixes);
        closure.call();
    }

    public void tag(Closure<?> closure) {
        this.mTagConfig.mTagMappings.clear();
        closure.setResolveStrategy(1);
        closure.setDelegate((Object)this.mTagConfig);
        closure.call();
    }
}

