/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.gver.dsl;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.dmfs.gver.dsl.ConditionConsumer;
import org.dmfs.gver.dsl.Conditions;
import org.dmfs.gver.git.ChangeType;
import org.dmfs.gver.git.ChangeTypeStrategy;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class Strategy {
    public final List<ChangeTypeStrategy> mChangeTypeStrategies;
    public static final ChangeType major = ChangeType.MAJOR;
    public static final ChangeType minor = ChangeType.MINOR;
    public static final ChangeType patch = ChangeType.PATCH;
    public static final ChangeType none = ChangeType.NONE;
    public static final ChangeType invalid = ChangeType.INVALID;

    public Strategy() {
        this(new ChangeTypeStrategy[0]);
    }

    public Strategy(ChangeTypeStrategy ... strategies) {
        this.mChangeTypeStrategies = new ArrayList<ChangeTypeStrategy>(InvokerHelper.asList((Object)strategies));
    }

    public ConditionConsumer are(final ChangeType changeType) {
        return new ConditionConsumer(){

            @Override
            public void when(Closure<?> condition) {
                Conditions conditions = new Conditions();
                condition.setResolveStrategy(1);
                condition.setDelegate((Object)conditions);
                condition.call();
                Strategy.this.mChangeTypeStrategies.add(changeType.when(conditions));
            }

            @Override
            public Void getOtherwise() {
                Strategy.this.mChangeTypeStrategies.add(changeType.when((Repository repository, RevCommit commit, String branches) -> true));
                return null;
            }
        };
    }

    @Deprecated
    public void otherwise(ChangeType changeType) {
        this.mChangeTypeStrategies.add(changeType.when((repository, commit, branches) -> true));
    }

    public void follow(Closure strategy) {
        strategy.setResolveStrategy(1);
        strategy.setDelegate((Object)this);
        strategy.call();
    }
}

