/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.gver.dsl.function;

import java.io.IOException;
import org.dmfs.gver.dsl.ApplicableReleaseTypes;
import org.dmfs.gver.dsl.GitVersionConfig;
import org.dmfs.gver.dsl.ReleaseType;
import org.dmfs.jems2.FragileFunction;
import org.dmfs.jems2.Optional;
import org.dmfs.jems2.Predicate;
import org.dmfs.jems2.optional.First;
import org.dmfs.jems2.optional.Mapped;
import org.dmfs.semver.Version;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public final class EffectiveVersion
implements FragileFunction<Repository, Optional<Version>, IOException> {
    private final Predicate<ReleaseType> mReleaseType;
    private final GitVersionConfig mGitVersionConfig;
    private final Version mVersion;

    public EffectiveVersion(Predicate<ReleaseType> releaseType, GitVersionConfig gitVersionConfig, Version version) {
        this.mReleaseType = releaseType;
        this.mGitVersionConfig = gitVersionConfig;
        this.mVersion = version;
    }

    public Optional<Version> value(Repository repository) throws IOException {
        ObjectId headId = repository.resolve("HEAD");
        RevCommit head = repository.parseCommit((AnyObjectId)headId);
        return new Mapped(releaseType -> releaseType.value(this.mVersion), (Optional)new First(this.mReleaseType, (Iterable)((Object)new ApplicableReleaseTypes(this.mGitVersionConfig, repository, head, repository.getBranch()))));
    }
}

